/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FilterDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FilterSetDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.Path;

public class FilterSet {
    protected FilterSetDescriptor descriptor;
    private Filter[] filters;

    public FilterSet(FilterSetDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean matches(String pathInfo) {
        return this.descriptor.matches(pathInfo);
    }

    public boolean matches(Path pathInfo) {
        return this.descriptor.matches(pathInfo);
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            List<FilterDescriptor> fds = this.descriptor.getFilters();
            this.filters = new Filter[fds.size()];
            int len = fds.size();
            for (int i = 0; i < len; ++i) {
                FilterDescriptor fd = fds.get(i);
                Filter filter = fd.getFilter();
                filter.init((FilterConfig)new FilterConfigAdapter(fd, config));
                this.filters[i] = filter;
            }
        }
        catch (Exception e) {
            throw new ServletException("Failed to initialize filter set", (Throwable)e);
        }
    }

    public void destroy() {
        for (Filter filter : this.filters) {
            filter.destroy();
        }
        this.descriptor = null;
        this.filters = null;
    }

    static class FilterConfigAdapter
    implements FilterConfig {
        protected final ServletConfig config;
        protected final FilterDescriptor fd;

        public FilterConfigAdapter(FilterDescriptor fd, ServletConfig config) {
            this.fd = fd;
            this.config = config;
        }

        public String getFilterName() {
            return this.fd.getRawClassRef();
        }

        public String getInitParameter(String key) {
            return this.fd.getInitParams().get(key);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.fd.getInitParams().keySet());
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }
    }
}

