/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.jboss;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.CachableUserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPropagator;

public class JBossAuthenticationPropagator
implements NuxeoAuthenticationPropagator {
    public NuxeoAuthenticationPropagator.CleanupCallback propagateUserIdentificationInformation(CachableUserIdentificationInfo cachableUserIdent) {
        UserIdentificationInfo userInfo = cachableUserIdent.getUserInfo();
        final char[] password = userInfo.getPassword().toCharArray();
        final UserIdentificationInfo cred = userInfo;
        final boolean useLP = userInfo.getLoginPluginName() != null;
        final Principal prin = cachableUserIdent.getPrincipal();
        final Subject subj = cachableUserIdent.getLoginContext().getSubject();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (useLP) {
                    SecurityAssociation.pushSubjectContext((Subject)subj, (Principal)prin, (Object)cred);
                } else {
                    SecurityAssociation.pushSubjectContext((Subject)subj, (Principal)prin, (Object)password);
                }
                return null;
            }
        });
        return new NuxeoAuthenticationPropagator.CleanupCallback(){

            public void cleanup() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.popSubjectContext();
                        return null;
                    }
                });
            }
        };
    }
}

