/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.IdGenerator;

public class SimpleIdGenerator
implements IdGenerator {
    private int nextId;

    public SimpleIdGenerator(Connection sqlConnection, Table table, String idColumn) throws DirectoryException {
        Select select = new Select(table);
        select.setWhat("max(" + table.getColumn(idColumn).getQuotedName() + ")");
        select.setFrom(table.getQuotedName());
        String sql = select.getStatement();
        PreparedStatement ps = null;
        try {
            ps = sqlConnection.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            this.nextId = rs.next() ? rs.getInt(1) : 0;
            ++this.nextId;
            rs.close();
        }
        catch (SQLException e) {
            throw new DirectoryException("nextIdGenerator retrieval failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public int nextId() throws DirectoryException {
        if (this.nextId == -1) {
            throw new DirectoryException("Id generator not initialized");
        }
        return this.nextId++;
    }
}

