/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ejb;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.platform.interfaces.ejb.ECContentRoot;
import org.nuxeo.ecm.platform.interfaces.local.ECContentRootLocal;

@Stateless
public class ECContentRootBean
implements ECContentRoot,
ECContentRootLocal {
    private static final Log log = LogFactory.getLog(ECContentRootBean.class);

    @Override
    public void remove() {
    }

    @Override
    public List<DocumentModel> getContentRootChildren(String documentType, DocumentRef docRef, CoreSession handle) throws ClientException {
        FacetFilter facetFilter = new FacetFilter("HiddenInNavigation", false);
        try {
            assert (null != docRef);
            assert (null != handle);
            log.debug((Object)("Making call to get the children for doc id:" + docRef));
            DocumentModelList children = handle.getChildren(docRef, null, "Read", (Filter)facetFilter, null);
            assert (null != children);
            List contentRootChildren = null;
            for (DocumentModel indexDocumentModel : children) {
                if (!documentType.equalsIgnoreCase((String)indexDocumentModel.getProperty("dublincore", "description"))) continue;
                log.debug((Object)("Making call to get the children for doc id:" + docRef));
                contentRootChildren = handle.getChildren(indexDocumentModel.getRef(), null, "Read", (Filter)facetFilter, null);
                break;
            }
            ArrayList<DocumentModel> filteredDocuments = new ArrayList<DocumentModel>();
            if (null != contentRootChildren) {
                for (DocumentModel document : contentRootChildren) {
                    if (!document.getType().equalsIgnoreCase(documentType)) continue;
                    filteredDocuments.add(document);
                }
            }
            return filteredDocuments;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public List<DocumentModel> getContentRootDocuments(DocumentRef docRef, CoreSession handle) throws ClientException {
        FacetFilter facetFilter = new FacetFilter("HiddenInNavigation", false);
        try {
            assert (null != docRef);
            assert (null != handle);
            log.debug((Object)("Making call to get the children for doc id:" + docRef));
            DocumentModelList contentRootDocuments = handle.getChildren(docRef, null, "Read", (Filter)facetFilter, null);
            assert (null != contentRootDocuments);
            return contentRootDocuments;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }
}

