/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.TransientDocument;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoFileableObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;

public class NuxeoDocument
extends NuxeoFileableObject
implements Document {
    public NuxeoDocument(NuxeoSession session, NuxeoObjectData data, ObjectType type) {
        super(session, data, type);
    }

    public TransientDocument getTransientDocument() {
        return this.getAdapter(TransientDocument.class);
    }

    public void cancelCheckOut() {
        this.service.cancelCheckOut(this.getId());
    }

    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment) {
        String verId = this.service.checkIn(this.getId(), major, properties, this.type, contentStream, checkinComment);
        return this.session.createObjectId(verId);
    }

    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        return this.checkIn(major, properties, contentStream, checkinComment);
    }

    public ObjectId checkOut() {
        String pwcId = this.service.checkOut(this.getId());
        return this.session.createObjectId(pwcId);
    }

    public NuxeoDocument copy(ObjectId target) {
        return this.copy(target, (Map)null, (VersioningState)null, (List)null, (List)null, (List)null, this.session.getDefaultContext());
    }

    public NuxeoDocument copy(ObjectId target, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        if (target == null || target.getId() == null) {
            throw new CmisInvalidArgumentException("Invalid target: " + target);
        }
        if (context == null) {
            context = this.session.getDefaultContext();
        }
        NuxeoObjectData newData = this.service.copy(this.getId(), target.getId(), properties, (TypeDefinition)this.type, versioningState, policies, addACEs, removeACEs, context);
        return (NuxeoDocument)this.session.getObjectFactory().convertObject(newData, context);
    }

    public void deleteAllVersions() {
        throw new UnsupportedOperationException();
    }

    public NuxeoDocument deleteContentStream() {
        ObjectId objectId = this.deleteContentStream(true);
        return (NuxeoDocument)this.session.getObject(objectId);
    }

    public ObjectId deleteContentStream(boolean refresh) {
        Holder objectIdHolder = new Holder((Object)this.getId());
        String changeToken = (String)this.getPropertyValue("cmis:changeToken");
        Holder changeTokenHolder = new Holder((Object)changeToken);
        this.service.deleteContentStream(this.getRepositoryId(), (Holder<String>)objectIdHolder, (Holder<String>)changeTokenHolder, null);
        String objectId = (String)objectIdHolder.getValue();
        return this.session.createObjectId(objectId);
    }

    public List<Document> getAllVersions() {
        throw new UnsupportedOperationException();
    }

    public List<Document> getAllVersions(OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public String getCheckinComment() {
        return (String)this.getPropertyValue("cmis:checkinComment");
    }

    public ContentStream getContentStream() {
        return this.getContentStream(null);
    }

    public ContentStream getContentStream(String streamId) {
        try {
            return this.service.getContentStream(this.getRepositoryId(), this.getId(), streamId, null, null, null);
        }
        catch (CmisConstraintException e) {
            return null;
        }
    }

    public String getContentStreamFileName() {
        return (String)this.getPropertyValue("cmis:contentStreamFileName");
    }

    public String getContentStreamId() {
        return (String)this.getPropertyValue("cmis:contentStreamId");
    }

    public long getContentStreamLength() {
        Long length = (Long)this.getPropertyValue("cmis:contentStreamLength");
        return length == null ? -1L : length;
    }

    public String getContentStreamMimeType() {
        return (String)this.getPropertyValue("cmis:contentStreamMimeType");
    }

    public Document getObjectOfLatestVersion(boolean major) {
        throw new UnsupportedOperationException();
    }

    public Document getObjectOfLatestVersion(boolean major, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public String getVersionLabel() {
        return (String)this.getPropertyValue("cmis:versionLabel");
    }

    public String getVersionSeriesCheckedOutBy() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutBy");
    }

    public String getVersionSeriesCheckedOutId() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutId");
    }

    public String getVersionSeriesId() {
        return (String)this.getPropertyValue("cmis:versionSeriesId");
    }

    public Boolean isImmutable() {
        return (Boolean)this.getPropertyValue("cmis:isImmutable");
    }

    public Boolean isLatestMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestMajorVersion");
    }

    public Boolean isLatestVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestVersion");
    }

    public Boolean isMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isMajorVersion");
    }

    public Boolean isVersionSeriesCheckedOut() {
        return (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
    }

    public Document setContentStream(ContentStream contentStream, boolean overwrite) {
        ObjectId objectId = this.setContentStream(contentStream, overwrite, true);
        return (NuxeoDocument)this.session.getObject(objectId);
    }

    public ObjectId setContentStream(ContentStream contentStream, boolean overwrite, boolean refresh) {
        Holder objectIdHolder = new Holder((Object)this.getId());
        String changeToken = (String)this.getPropertyValue("cmis:changeToken");
        Holder changeTokenHolder = new Holder((Object)changeToken);
        this.service.setContentStream(this.getRepositoryId(), (Holder<String>)objectIdHolder, overwrite, (Holder<String>)changeTokenHolder, contentStream, null);
        String objectId = (String)objectIdHolder.getValue();
        return this.session.createObjectId(objectId);
    }
}

