/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.PropertyImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.DocumentTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.FolderTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.PolicyTypeImpl;
import org.apache.chemistry.opencmis.client.runtime.objecttype.RelationshipTypeImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;

public class NuxeoObjectFactory
implements ObjectFactory {
    private final NuxeoSession session;
    private static final BindingsObjectFactory of = new BindingsObjectFactoryImpl();

    public NuxeoObjectFactory(NuxeoSession session) {
        this.session = session;
    }

    public void initialize(Session session, Map<String, String> parameters) {
        throw new UnsupportedOperationException();
    }

    public NuxeoObject convertObject(ObjectData data, OperationContext context) {
        if (data == null || data.getProperties() == null || data.getProperties().getProperties() == null) {
            return null;
        }
        PropertyData propData = (PropertyData)data.getProperties().getProperties().get("cmis:objectTypeId");
        if (!(propData instanceof PropertyId)) {
            throw new IllegalArgumentException("Property cmis:objectTypeId must be of type PropertyIdData, not: " + propData.getClass().getName());
        }
        ObjectType type = this.session.getTypeDefinition((String)propData.getFirstValue());
        return NuxeoObject.construct(this.session, (NuxeoObjectData)data, type);
    }

    public ObjectType getTypeFromObjectData(ObjectData objectData) {
        throw new UnsupportedOperationException();
    }

    public Ace createAce(String principal, List<String> permissions) {
        throw new UnsupportedOperationException();
    }

    public Acl createAcl(List<Ace> aces) {
        throw new UnsupportedOperationException();
    }

    public <T> Property<T> createProperty(PropertyDefinition<T> type, List<T> values) {
        return new PropertyImpl(type, values);
    }

    public ContentStream createContentStream(String filename, long length, String mimetype, InputStream stream) {
        return new ContentStreamImpl(filename, BigInteger.valueOf(length), mimetype, stream);
    }

    public Acl convertAces(List<Ace> aces) {
        return aces == null ? null : new AccessControlListImpl(aces);
    }

    public ContentStream convertContentStream(ContentStream contentStream) {
        throw new UnsupportedOperationException();
    }

    public List<String> convertPolicies(List<Policy> policies) {
        if (policies == null) {
            return null;
        }
        ArrayList<String> policyIds = new ArrayList<String>(policies.size());
        for (Policy p : policies) {
            policyIds.add(p.getId());
        }
        return policyIds;
    }

    public Map<String, Property<?>> convertProperties(ObjectType objectType, Properties properties) {
        throw new UnsupportedOperationException();
    }

    public Properties convertProperties(Map<String, ?> properties, ObjectType type, Set<Updatability> updatabilityFilter) {
        PropertiesImpl props = new PropertiesImpl();
        for (Map.Entry<String, ?> es : properties.entrySet()) {
            PropertyData<?> prop = NuxeoObjectFactory.convertProperty(es.getKey(), es.getValue(), type);
            props.addProperty(prop);
        }
        return props;
    }

    protected static PropertyData<?> convertProperty(String key, Object value, ObjectType type) {
        Object firstValue;
        List<Object> values;
        boolean single;
        PropertyDefinition pd = (PropertyDefinition)type.getPropertyDefinitions().get(key);
        if (pd == null) {
            throw new IllegalArgumentException("Unknown property '" + key + "' for type: " + type.getId());
        }
        boolean bl = single = pd.getCardinality() == Cardinality.SINGLE;
        if (value == null) {
            values = null;
        } else if (value instanceof List) {
            if (single) {
                throw new IllegalArgumentException("Property '" + key + "' is not a multi value property!");
            }
            values = (List)value;
        } else {
            if (!single) {
                throw new IllegalArgumentException("Property '" + key + "' is not a single value property!");
            }
            values = Collections.singletonList(value);
        }
        Object v1 = firstValue = values == null ? null : values.get(0);
        if (pd instanceof PropertyStringDefinition) {
            return of.createPropertyStringData(key, values);
        }
        if (pd instanceof PropertyIdDefinition) {
            return of.createPropertyIdData(key, values);
        }
        if (pd instanceof PropertyHtmlDefinition) {
            return of.createPropertyHtmlData(key, values);
        }
        if (pd instanceof PropertyUriDefinition) {
            return of.createPropertyUriData(key, values);
        }
        if (pd instanceof PropertyIntegerDefinition) {
            if (firstValue == null) {
                return of.createPropertyIntegerData(key, (List)null);
            }
            if (firstValue instanceof BigInteger) {
                return of.createPropertyIntegerData(key, values);
            }
            if (firstValue instanceof Byte || firstValue instanceof Short || firstValue instanceof Integer || firstValue instanceof Long) {
                ArrayList<BigInteger> list = new ArrayList<BigInteger>(values.size());
                for (Object v : values) {
                    list.add(BigInteger.valueOf(((Number)v).longValue()));
                }
                return of.createPropertyIntegerData(key, list);
            }
            throw new IllegalArgumentException("Property '" + key + "' is an Integer property");
        }
        if (pd instanceof PropertyBooleanDefinition) {
            return of.createPropertyBooleanData(key, values);
        }
        if (pd instanceof PropertyDecimalDefinition) {
            return of.createPropertyDecimalData(key, values);
        }
        if (pd instanceof PropertyDateTimeDefinition) {
            return of.createPropertyDateTimeData(key, values);
        }
        throw new CmisRuntimeException("Unknown class: " + pd.getClass().getName());
    }

    public List<PropertyData<?>> convertQueryProperties(Properties properties) {
        throw new UnsupportedOperationException();
    }

    public QueryResult convertQueryResult(ObjectData objectData) {
        throw new UnsupportedOperationException();
    }

    public Rendition convertRendition(String objectId, RenditionData rendition) {
        throw new UnsupportedOperationException();
    }

    public ObjectType convertTypeDefinition(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof DocumentTypeDefinition) {
            return new DocumentTypeImpl((Session)this.session, (DocumentTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof FolderTypeDefinition) {
            return new FolderTypeImpl((Session)this.session, (FolderTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof RelationshipTypeDefinition) {
            return new RelationshipTypeImpl((Session)this.session, (RelationshipTypeDefinition)typeDefinition);
        }
        if (typeDefinition instanceof PolicyTypeDefinition) {
            return new PolicyTypeImpl((Session)this.session, (PolicyTypeDefinition)typeDefinition);
        }
        throw new CmisRuntimeException("Unknown base class: " + typeDefinition.getClass().getName());
    }

    public ChangeEvent convertChangeEvent(ObjectData objectData) {
        throw new UnsupportedOperationException();
    }

    public ChangeEvents convertChangeEvents(String changeLogToken, ObjectList objectList) {
        throw new UnsupportedOperationException();
    }
}

