/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Serializer;
import jdbm.recman.Location;
import jdbm.recman.LogicalRowIdManager;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowIdManager;
import jdbm.recman.RecordFile;
import jdbm.recman.TransactionManager;

public final class BaseRecordManager
implements RecordManager {
    private RecordFile _file;
    private PhysicalRowIdManager _physMgr;
    private LogicalRowIdManager _logMgr;
    private PageManager _pageman;
    public static final int NAME_DIRECTORY_ROOT = 0;
    public static final boolean DEBUG = false;
    private Map _nameDirectory;

    public BaseRecordManager(String filename) throws IOException {
        this._file = new RecordFile(filename);
        this._pageman = new PageManager(this._file);
        this._physMgr = new PhysicalRowIdManager(this._file, this._pageman);
        this._logMgr = new LogicalRowIdManager(this._file, this._pageman);
    }

    public synchronized TransactionManager getTransactionManager() {
        this.checkIfClosed();
        return this._file.txnMgr;
    }

    public synchronized void disableTransactions() {
        this.checkIfClosed();
        this._file.disableTransactions();
    }

    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this._pageman.close();
        this._pageman = null;
        this._file.close();
        this._file = null;
    }

    public long insert(Object obj) throws IOException {
        return this.insert(obj, DefaultSerializer.INSTANCE);
    }

    public synchronized long insert(Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        byte[] data = serializer.serialize(obj);
        Location physRowId = this._physMgr.insert(data, 0, data.length);
        long recid = this._logMgr.insert(physRowId).toLong();
        return recid;
    }

    public synchronized void delete(long recid) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        Location logRowId = new Location(recid);
        Location physRowId = this._logMgr.fetch(logRowId);
        this._physMgr.delete(physRowId);
        this._logMgr.delete(logRowId);
    }

    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, DefaultSerializer.INSTANCE);
    }

    public synchronized void update(long recid, Object obj, Serializer serializer) throws IOException {
        byte[] data;
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        Location logRecid = new Location(recid);
        Location physRecid = this._logMgr.fetch(logRecid);
        Location newRecid = this._physMgr.update(physRecid, data = serializer.serialize(obj), 0, data.length);
        if (!newRecid.equals(physRecid)) {
            this._logMgr.update(logRecid, newRecid);
        }
    }

    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, DefaultSerializer.INSTANCE);
    }

    public synchronized Object fetch(long recid, Serializer serializer) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        byte[] data = this._physMgr.fetch(this._logMgr.fetch(new Location(recid)));
        return serializer.deserialize(data);
    }

    public int getRootCount() {
        return 1013;
    }

    public synchronized long getRoot(int id) throws IOException {
        this.checkIfClosed();
        return this._pageman.getFileHeader().getRoot(id);
    }

    public synchronized void setRoot(int id, long rowid) throws IOException {
        this.checkIfClosed();
        this._pageman.getFileHeader().setRoot(id, rowid);
    }

    public long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        Map nameDirectory = this.getNameDirectory();
        Long recid = (Long)nameDirectory.get(name);
        if (recid == null) {
            return 0L;
        }
        return recid;
    }

    public void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        Map nameDirectory = this.getNameDirectory();
        if (recid == 0L) {
            nameDirectory.remove(name);
        } else {
            nameDirectory.put(name, new Long(recid));
        }
        this.saveNameDirectory(nameDirectory);
    }

    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this._pageman.commit();
    }

    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this._pageman.rollback();
    }

    private Map getNameDirectory() throws IOException {
        long nameDirectory_recid = this.getRoot(0);
        if (nameDirectory_recid == 0L) {
            this._nameDirectory = new HashMap();
            nameDirectory_recid = this.insert(this._nameDirectory);
            this.setRoot(0, nameDirectory_recid);
        } else {
            this._nameDirectory = (Map)this.fetch(nameDirectory_recid);
        }
        return this._nameDirectory;
    }

    private void saveNameDirectory(Map directory) throws IOException {
        long recid = this.getRoot(0);
        if (recid == 0L) {
            throw new IOException("Name directory must exist");
        }
        this.update(recid, this._nameDirectory);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this._file == null) {
            throw new IllegalStateException("RecordManager has been closed");
        }
    }
}

