/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.PageProvider", category="Fetch", label="PageProvider", description="Perform a query or a named provider query on the repository. Result is paginated. The query result will become the input for the next operation. If no query or provider name is given, a query returning all the documents that the user has access to will be executed.")
public class DocumentPageProviderOperation {
    public static final String ID = "Document.PageProvider";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    @Context
    protected CoreSession session;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Param(name="query", required=false)
    protected String query;
    @Param(name="language", required=false, widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="page", required=false)
    protected Integer page;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Param(name="sortInfo", required=false)
    protected StringList sortInfoAsStringList;
    @Param(name="queryParams", required=false)
    protected StringList strParameters;

    @OperationMethod
    public DocumentModelList run() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        if (this.sortInfoAsStringList != null) {
            for (String sortInfoDesc : this.sortInfoAsStringList) {
                SortInfo sortInfo;
                if (sortInfoDesc.contains(":")) {
                    String[] parts = sortInfoDesc.split(":");
                    sortInfo = new SortInfo(parts[0], Boolean.parseBoolean(parts[1]));
                } else {
                    sortInfo = new SortInfo(sortInfoDesc, true);
                }
                sortInfos.add(sortInfo);
            }
        }
        Object[] parameters = null;
        if (this.strParameters != null && !this.strParameters.isEmpty()) {
            parameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = this.session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.session.getRepositoryName();
            }
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        if (this.query == null && (this.providerName == null || this.providerName.length() == 0)) {
            this.query = "SELECT * from Document";
        }
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        if (this.query != null) {
            CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
            desc.setPattern(this.query);
            return new PaginableDocumentModelListImpl((PageProvider<DocumentModel>)pps.getPageProvider("", (PageProviderDefinition)desc, sortInfos, targetPageSize, targetPage, props, parameters));
        }
        return new PaginableDocumentModelListImpl((PageProvider<DocumentModel>)pps.getPageProvider(this.providerName, sortInfos, targetPageSize, targetPage, props, parameters));
    }
}

