/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.builder;

import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import org.jmock.builder.ArgumentsMatchBuilder;
import org.jmock.builder.BuilderNamespace;
import org.jmock.builder.IdentityBuilder;
import org.jmock.builder.MatchBuilder;
import org.jmock.builder.NameMatchBuilder;
import org.jmock.core.Constraint;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.Stub;
import org.jmock.core.StubMatchersCollection;
import org.jmock.core.constraint.IsNull;
import org.jmock.core.matcher.AnyArgumentsMatcher;
import org.jmock.core.matcher.ArgumentsMatcher;
import org.jmock.core.matcher.InvokedAfterMatcher;
import org.jmock.core.matcher.InvokedRecorder;
import org.jmock.core.matcher.MethodNameMatcher;
import org.jmock.core.matcher.NoArgumentsMatcher;
import org.jmock.core.stub.VoidStub;

public class InvocationMockerBuilder
implements NameMatchBuilder {
    private StubMatchersCollection mocker;
    private BuilderNamespace builderNamespace;
    private Class mockedType;
    static /* synthetic */ Class class$java$lang$Object;

    public InvocationMockerBuilder(StubMatchersCollection mocker, BuilderNamespace idTable, Class mockedType) {
        this.mocker = mocker;
        this.builderNamespace = idTable;
        this.mockedType = mockedType;
    }

    public ArgumentsMatchBuilder method(Constraint nameConstraint) {
        return this.addMatcher(new MethodNameMatcher(nameConstraint));
    }

    public ArgumentsMatchBuilder method(String name) {
        this.checkLegalMethodName(name);
        this.checkExistingMethodName(name);
        this.addMatcher(new MethodNameMatcher(name));
        this.builderNamespace.registerMethodName(name, this);
        return this;
    }

    private void checkLegalMethodName(String name) {
        if (!this.isLegalMethodName(name)) {
            throw new IllegalArgumentException("illegal method name: " + name + " is not a legal Java identifier");
        }
    }

    private boolean isLegalMethodName(String name) {
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void checkExistingMethodName(String name) {
        if (!this.typeDefinesMethodNamed(this.mockedType, name) && !this.typeDefinesMethodNamed(class$java$lang$Object == null ? (class$java$lang$Object = InvocationMockerBuilder.class$("java.lang.Object")) : class$java$lang$Object, name)) {
            throw new AssertionFailedError("no method named " + name + " is defined in type " + this.mockedType);
        }
    }

    private boolean typeDefinesMethodNamed(Class type, String name) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public MatchBuilder match(InvocationMatcher customMatcher) {
        return this.addMatcher(customMatcher);
    }

    public MatchBuilder with(Constraint arg1) {
        return this.with(new Constraint[]{arg1});
    }

    public MatchBuilder with(Constraint arg1, Constraint arg2) {
        return this.with(new Constraint[]{arg1, arg2});
    }

    public MatchBuilder with(Constraint arg1, Constraint arg2, Constraint arg3) {
        return this.with(new Constraint[]{arg1, arg2, arg3});
    }

    public MatchBuilder with(Constraint arg1, Constraint arg2, Constraint arg3, Constraint arg4) {
        return this.with(new Constraint[]{arg1, arg2, arg3, arg4});
    }

    public MatchBuilder with(Constraint[] constraints) {
        for (int i = 0; i < constraints.length; ++i) {
            if (constraints[i] != null) continue;
            constraints[i] = new IsNull();
        }
        return this.addMatcher(new ArgumentsMatcher(constraints));
    }

    public MatchBuilder withNoArguments() {
        return this.addMatcher(NoArgumentsMatcher.INSTANCE);
    }

    public MatchBuilder withAnyArguments() {
        return this.addMatcher(AnyArgumentsMatcher.INSTANCE);
    }

    public IdentityBuilder will(Stub stubAction) {
        this.setStub(stubAction);
        return this;
    }

    public IdentityBuilder isVoid() {
        this.setStub(VoidStub.INSTANCE);
        return this;
    }

    private void setStub(Stub stubAction) {
        this.mocker.setStub(stubAction);
    }

    public IdentityBuilder expect(InvocationMatcher expectation) {
        return this.addMatcher(expectation);
    }

    public void id(String invocationID) {
        this.mocker.setName(invocationID);
        this.builderNamespace.registerUniqueID(invocationID, this);
    }

    public MatchBuilder after(String priorCallID) {
        this.setupOrderingMatchers(this.builderNamespace, priorCallID, priorCallID);
        return this;
    }

    public MatchBuilder after(BuilderNamespace otherMock, String priorCallID) {
        this.setupOrderingMatchers(otherMock, priorCallID, priorCallID + " on " + otherMock);
        return this;
    }

    private void setupOrderingMatchers(BuilderNamespace idTable, String priorCallID, String priorCallDescription) {
        MatchBuilder priorCallBuilder = idTable.lookupID(priorCallID);
        if (priorCallBuilder == this) {
            throw new AssertionFailedError("confusing identifier of prior invocation \"" + priorCallID + "\"; " + "give it an explicit call identifier");
        }
        InvokedRecorder priorCallRecorder = new InvokedRecorder();
        priorCallBuilder.match(priorCallRecorder);
        this.mocker.addMatcher(new InvokedAfterMatcher(priorCallRecorder, priorCallDescription));
    }

    private InvocationMockerBuilder addMatcher(InvocationMatcher matcher) {
        this.mocker.addMatcher(matcher);
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

