/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Array;
import java.util.Collection;

public class Formatting {
    public static String toReadableString(Object element) {
        if (element == null) {
            return "null";
        }
        if (element instanceof String) {
            return Formatting.toJavaSyntax((String)element);
        }
        if (element instanceof Character) {
            return "'" + Formatting.toJavaSyntax(((Character)element).charValue()) + "'";
        }
        if (element instanceof Short) {
            return "<" + element.toString() + "s>";
        }
        if (element instanceof Long) {
            return "<" + element.toString() + "L>";
        }
        if (element instanceof Float) {
            return "<" + element.toString() + "F>";
        }
        if (element.getClass().isArray()) {
            return Formatting.join(element, new StringBuffer()).toString();
        }
        return "<" + element.toString() + ">";
    }

    private static String toJavaSyntax(String unformatted) {
        StringBuffer formatted = new StringBuffer();
        formatted.append('\"');
        for (int i = 0; i < unformatted.length(); ++i) {
            formatted.append(Formatting.toJavaSyntax(unformatted.charAt(i)));
        }
        formatted.append('\"');
        return formatted.toString();
    }

    private static String toJavaSyntax(char ch) {
        switch (ch) {
            case '\"': {
                return "\\\"";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return new String(new char[]{ch});
    }

    public static StringBuffer join(Object array, StringBuffer buf) {
        return Formatting.join(array, buf, "[", "]");
    }

    public static StringBuffer join(Collection collection, StringBuffer buf, String prefix, String postfix) {
        return Formatting.join(collection.toArray(), buf, prefix, postfix);
    }

    public static StringBuffer join(Collection collection, StringBuffer buf, String prefix, String separator, String postfix) {
        return Formatting.join(collection.toArray(), buf, prefix, separator, postfix);
    }

    public static StringBuffer join(Object array, StringBuffer buf, String prefix, String postfix) {
        return Formatting.join(array, buf, prefix, ", ", postfix);
    }

    public static StringBuffer join(Object array, StringBuffer buf, String prefix, String separator, String postfix) {
        buf.append(prefix);
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(Formatting.toReadableString(Array.get(array, i)));
        }
        buf.append(postfix);
        return buf;
    }

    public static String classShortName(Class c) {
        String fullTypeName = c.getName();
        return fullTypeName.substring(Math.max(fullTypeName.lastIndexOf(46), fullTypeName.lastIndexOf(36)) + 1);
    }
}

