/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.IdGenerator;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.multi.MultiDirectoryDescriptor;
import org.nuxeo.ecm.directory.multi.MultiDirectoryFactory;
import org.nuxeo.ecm.directory.multi.MultiDirectorySession;
import org.nuxeo.ecm.directory.multi.MultiReference;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;
import org.nuxeo.ecm.directory.multi.SubDirectoryDescriptor;

public class MultiDirectory
extends AbstractDirectory {
    private final MultiDirectoryDescriptor descriptor;
    private Set<MultiDirectorySession> sessions;

    public MultiDirectory(MultiDirectoryDescriptor descriptor) {
        this.descriptor = descriptor;
        this.sessions = new HashSet<MultiDirectorySession>();
    }

    protected MultiDirectoryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IdGenerator getIdGenerator() {
        return null;
    }

    public String getName() {
        return this.descriptor.name;
    }

    public String getSchema() {
        return this.descriptor.schemaName;
    }

    public String getParentDirectory() {
        return null;
    }

    public String getIdField() {
        return this.descriptor.idField;
    }

    public String getPasswordField() {
        return this.descriptor.passwordField;
    }

    public Session getSession() throws DirectoryException {
        MultiDirectorySession session = new MultiDirectorySession(this);
        this.addSession(session);
        return session;
    }

    protected void addSession(MultiDirectorySession session) {
        this.sessions.add(session);
    }

    protected void removeSession(Session session) {
        this.sessions.remove(session);
    }

    public void shutdown() throws DirectoryException {
        try {
            for (Object session : this.sessions.toArray()) {
                ((Session)session).close();
            }
            this.sessions = null;
        }
        catch (ClientException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public Reference getReference(String referenceFieldName) {
        return new MultiReference(this, referenceFieldName);
    }

    public void invalidateDirectoryCache() throws DirectoryException {
        this.getCache().invalidateAll();
        for (SourceDescriptor src : this.descriptor.sources) {
            for (SubDirectoryDescriptor sub : src.subDirectories) {
                Directory dir = MultiDirectoryFactory.getDirectoryService().getDirectory(sub.name);
                if (dir == null) continue;
                dir.invalidateDirectoryCache();
            }
        }
    }
}

