/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.ejb;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.ejb.UserManagerLocal;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Remote(value={UserManager.class})
@Local(value={UserManagerLocal.class})
public class UserManagerBean
implements UserManagerLocal {
    private static final long serialVersionUID = 1L;
    private transient UserManager userManager;

    @Override
    @PostConstruct
    public void initialize() {
        this.getUserManager();
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)Framework.getLocalService(UserManager.class);
        }
        return this.userManager;
    }

    public void cleanup() {
    }

    public boolean checkUsernamePassword(String username, String password) throws ClientException {
        try {
            return this.getUserManager().checkUsernamePassword(username, password);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public boolean validatePassword(String password) throws ClientException {
        try {
            return this.getUserManager().validatePassword(password);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public NuxeoPrincipal getPrincipal(String username) throws ClientException {
        try {
            return this.getUserManager().getPrincipal(username);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<NuxeoPrincipal> searchPrincipals(String name) throws ClientException {
        try {
            return this.getUserManager().searchPrincipals(name);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<NuxeoGroup> searchGroups(String pattern) throws ClientException {
        try {
            return this.getUserManager().searchGroups(pattern);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public NuxeoGroup getGroup(String groupName) throws ClientException {
        try {
            return this.getUserManager().getGroup(groupName);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getDefaultGroup() {
        return this.getUserManager().getDefaultGroup();
    }

    public String getUserSortField() throws ClientException {
        try {
            return this.getUserManager().getUserSortField();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getUserListingMode() throws ClientException {
        try {
            return this.getUserManager().getUserListingMode();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getGroupListingMode() throws ClientException {
        try {
            return this.getUserManager().getGroupListingMode();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getUserDirectoryName() throws ClientException {
        try {
            return this.getUserManager().getUserDirectoryName();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getUserEmailField() throws ClientException {
        try {
            return this.getUserManager().getUserEmailField();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public Set<String> getUserSearchFields() throws ClientException {
        try {
            return this.getUserManager().getUserSearchFields();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getGroupDirectoryName() throws ClientException {
        try {
            return this.getUserManager().getGroupDirectoryName();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getGroupMembersField() throws ClientException {
        try {
            return this.getUserManager().getGroupMembersField();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getGroupSubGroupsField() throws ClientException {
        try {
            return this.getUserManager().getGroupSubGroupsField();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getGroupParentGroupsField() throws ClientException {
        try {
            return this.getUserManager().getGroupParentGroupsField();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<String> getGroupsInGroup(String parentId) throws ClientException {
        try {
            return this.getUserManager().getGroupsInGroup(parentId);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<String> getTopLevelGroups() throws ClientException {
        try {
            return this.getUserManager().getTopLevelGroups();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<String> getUsersInGroup(String groupId) throws ClientException {
        try {
            return this.getUserManager().getUsersInGroup(groupId);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<String> getUsersInGroupAndSubGroups(String groupId) throws ClientException {
        try {
            return this.getUserManager().getUsersInGroupAndSubGroups(groupId);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public Boolean areGroupsReadOnly() throws ClientException {
        try {
            return this.getUserManager().areGroupsReadOnly();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public Boolean areUsersReadOnly() throws ClientException {
        try {
            return this.getUserManager().areUsersReadOnly();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public Pattern getUserPasswordPattern() throws ClientException {
        try {
            return this.getUserManager().getUserPasswordPattern();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getAnonymousUserId() throws ClientException {
        try {
            return this.getUserManager().getAnonymousUserId();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getDigestAuthDirectory() throws ClientException {
        try {
            return this.getUserManager().getDigestAuthDirectory();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getDigestAuthRealm() throws ClientException {
        try {
            return this.getUserManager().getDigestAuthRealm();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void setConfiguration(UserManagerDescriptor descriptor) throws ClientException {
        try {
            this.getUserManager().setConfiguration(descriptor);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel getBareUserModel() throws ClientException {
        try {
            return this.getUserManager().getBareUserModel();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel createGroup(DocumentModel groupModel) throws ClientException {
        try {
            return this.getUserManager().createGroup(groupModel);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel createUser(DocumentModel userModel) throws ClientException {
        try {
            return this.getUserManager().createUser(userModel);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void deleteGroup(DocumentModel groupModel) throws ClientException {
        try {
            this.getUserManager().deleteGroup(groupModel);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void deleteUser(DocumentModel userModel) throws ClientException {
        try {
            this.getUserManager().deleteUser(userModel);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel getBareGroupModel() throws ClientException {
        try {
            return this.getUserManager().getBareGroupModel();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<String> getGroupIds() throws ClientException {
        try {
            return this.getUserManager().getGroupIds();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<String> getUserIds() throws ClientException {
        try {
            return this.getUserManager().getUserIds();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModelList searchGroups(Map<String, Serializable> filter, HashSet<String> fulltext) throws ClientException {
        try {
            return this.getUserManager().searchGroups(filter, fulltext);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext) throws ClientException {
        try {
            return this.getUserManager().searchUsers(filter, fulltext);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModelList searchUsers(String pattern) throws ClientException {
        try {
            return this.getUserManager().searchUsers(pattern);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void updateGroup(DocumentModel groupModel) throws ClientException {
        try {
            this.getUserManager().updateGroup(groupModel);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void updateUser(DocumentModel userModel) throws ClientException {
        try {
            this.getUserManager().updateUser(userModel);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void deleteGroup(String groupId) throws ClientException {
        try {
            this.getUserManager().deleteGroup(groupId);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void deleteUser(String userId) throws ClientException {
        try {
            this.getUserManager().deleteUser(userId);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel getGroupModel(String groupName) throws ClientException {
        try {
            return this.getUserManager().getGroupModel(groupName);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel getUserModel(String userName) throws ClientException {
        try {
            return this.getUserManager().getUserModel(userName);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getGroupIdField() throws ClientException {
        try {
            return this.getUserManager().getGroupIdField();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getGroupSchemaName() throws ClientException {
        try {
            return this.getUserManager().getGroupSchemaName();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getUserIdField() throws ClientException {
        try {
            return this.getUserManager().getUserIdField();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public String getUserSchemaName() throws ClientException {
        try {
            return this.getUserManager().getUserSchemaName();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void createGroup(NuxeoGroup group) throws ClientException {
        try {
            this.getUserManager().createGroup(group);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void createPrincipal(NuxeoPrincipal principal) throws ClientException {
        try {
            this.getUserManager().createPrincipal(principal);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void deleteGroup(NuxeoGroup group) throws ClientException {
        try {
            this.getUserManager().deleteGroup(group);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void deletePrincipal(NuxeoPrincipal principal) throws ClientException {
        try {
            this.getUserManager().deletePrincipal(principal);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<NuxeoGroup> getAvailableGroups() throws ClientException {
        try {
            return this.getUserManager().getAvailableGroups();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<NuxeoPrincipal> getAvailablePrincipals() throws ClientException {
        try {
            return this.getUserManager().getAvailablePrincipals();
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public DocumentModel getModelForUser(String name) throws ClientException {
        try {
            return this.getUserManager().getModelForUser(name);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<NuxeoPrincipal> searchByMap(Map<String, Serializable> filter, Set<String> pattern) throws ClientException {
        try {
            return this.getUserManager().searchByMap(filter, pattern);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void updateGroup(NuxeoGroup group) throws ClientException {
        try {
            this.getUserManager().updateGroup(group);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void updatePrincipal(NuxeoPrincipal principal) throws ClientException {
        try {
            this.getUserManager().updatePrincipal(principal);
        }
        catch (Throwable e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public List<String> getAdministratorsGroups() {
        return this.getUserManager().getAdministratorsGroups();
    }

    public String[] getUsersForPermission(String perm, ACP acp) {
        return this.getUserManager().getUsersForPermission(perm, acp);
    }

    public Principal authenticate(String name, String password) throws ClientException {
        try {
            return this.getUserManager().authenticate(name, password);
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ClientException(t);
        }
    }
}

