/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.backend.indexing.resources.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedData;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResource;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResources;

public class ResolvedResourcesImpl
implements ResolvedResources {
    private static final long serialVersionUID = 6245974901650687007L;
    protected String id;
    protected final Map<String, ResolvedResource> resolvedResources = new HashMap<String, ResolvedResource>();
    protected final List<ResolvedData> commonData = new ArrayList<ResolvedData>();
    protected final List<ResolvedData> mergedData = new ArrayList<ResolvedData>();
    protected ACP acp;

    public ResolvedResourcesImpl() {
    }

    public ResolvedResourcesImpl(String id) {
        this.id = id;
    }

    public ResolvedResourcesImpl(String id, List<ResolvedResource> resolvedResources, List<ResolvedData> commonData, ACP acp) {
        this.id = id;
        if (resolvedResources != null) {
            for (ResolvedResource res : resolvedResources) {
                String name = res.getConfiguration().getName();
                this.resolvedResources.put(name, res);
            }
        }
        if (commonData != null) {
            this.commonData.addAll(commonData);
        }
        this.acp = acp;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<ResolvedResource> getIndexableResolvedResources() {
        return new ArrayList<ResolvedResource>(this.resolvedResources.values());
    }

    @Override
    public List<ResolvedData> getMergedIndexableData() {
        if (this.resolvedResources.isEmpty()) {
            return this.mergedData;
        }
        if (this.mergedData.isEmpty()) {
            for (ResolvedResource resource : this.resolvedResources.values()) {
                List<ResolvedData> one = resource.getIndexableData();
                if (one == null) continue;
                this.mergedData.addAll(one);
            }
            if (this.commonData != null) {
                this.mergedData.addAll(this.commonData);
            }
        }
        return this.mergedData;
    }

    @Override
    public ACP getACP() {
        return this.acp;
    }

    @Override
    public ResolvedData getIndexableDataByName(String resourceName, String name) {
        ResolvedData data = null;
        ResolvedResource resource = this.getIndexableResolvedResourceByConfName(resourceName);
        if (resource != null) {
            data = resource.getIndexableDataByName(name);
        }
        return data;
    }

    @Override
    public ResolvedResource getIndexableResolvedResourceByConfName(String name) {
        if (this.resolvedResources.isEmpty()) {
            return null;
        }
        return this.resolvedResources.get(name);
    }

    @Override
    public List<ResolvedData> getCommonIndexableData() {
        return this.commonData;
    }
}

