/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client;

import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.search.api.backend.indexing.resources.ResolvedResources;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.SearchException;
import org.nuxeo.ecm.core.search.api.client.indexing.blobs.BlobExtractor;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResources;
import org.nuxeo.ecm.core.search.api.client.indexing.session.SearchServiceSession;
import org.nuxeo.ecm.core.search.api.client.query.ComposedNXQuery;
import org.nuxeo.ecm.core.search.api.client.query.NativeQuery;
import org.nuxeo.ecm.core.search.api.client.query.NativeQueryString;
import org.nuxeo.ecm.core.search.api.client.query.QueryException;
import org.nuxeo.ecm.core.search.api.client.query.SearchPrincipal;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultSet;
import org.nuxeo.ecm.core.search.api.events.IndexingEventConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.ResourceTypeDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.FulltextFieldDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.IndexableDocType;

public interface SearchService
extends Serializable {
    public SearchServiceSession openSession();

    public void closeSession(String var1);

    public void saveAllSessions() throws IndexingException;

    public boolean isEnabled();

    public void setStatus(boolean var1);

    public void index(IndexableResources var1, boolean var2) throws IndexingException;

    public void index(ResolvedResources var1) throws IndexingException;

    public void unindex(DocumentModel var1) throws IndexingException;

    public void clear() throws IndexingException;

    public void deleteAggregatedResources(String var1) throws IndexingException;

    public void deleteAtomicResource(String var1) throws IndexingException;

    @Deprecated
    public ResultSet searchQuery(ComposedNXQuery var1, int var2, int var3) throws SearchException, QueryException;

    @Deprecated
    public ResultSet searchQuery(NativeQuery var1, int var2, int var3) throws SearchException, QueryException;

    @Deprecated
    public ResultSet searchQuery(NativeQueryString var1, String var2, int var3, int var4) throws SearchException, QueryException;

    public List<String> getSupportedAnalyzersFor(String var1);

    public List<String> getSupportedFieldTypes(String var1);

    public IndexableDocType getIndexableDocTypeFor(String var1);

    public IndexableResourceConf getIndexableResourceConfByName(String var1, boolean var2);

    public IndexableResourceConf getIndexableResourceConfByPrefix(String var1, boolean var2);

    public Map<String, IndexableResourceConf> getIndexableResourceConfs();

    public String[] getAvailableBackendNames();

    public SearchPrincipal getSearchPrincipal(Principal var1);

    public FulltextFieldDescriptor getFullTextDescriptorByName(String var1);

    public IndexingEventConf getIndexingEventConfByName(String var1);

    public void invalidateComputedIndexableResourceConfs();

    public BlobExtractor getBlobExtractorByName(String var1);

    public ResourceTypeDescriptor getResourceTypeDescriptorByName(String var1);

    public int getNumberOfIndexingThreads();

    public long getIndexingWaitingQueueSize();

    public void setNumberOfIndexingThreads(int var1);

    public int getIndexingDocBatchSize();

    public void setIndexingDocBatchSize(int var1);

    @Deprecated
    public void reindexAll(String var1, String var2, boolean var3) throws IndexingException;

    public boolean isReindexingAll();

    public void setReindexingAll(boolean var1);

    public int getActiveIndexingTasks();

    public long getTotalCompletedIndexingTasks();
}

