/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.indexing.resources.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableFieldDescriptor;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceDataConf;

@XObject(value="resource")
public class IndexableResourceDescriptor
implements IndexableResourceConf {
    private static final long serialVersionUID = -6243415861302877651L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@prefix")
    protected String prefix;
    @XNode(value="@type")
    protected String type;
    @XNode(value="@indexAllFields")
    protected boolean allFieldsIndexable = false;
    @XNodeList(value="excludedField", type=HashSet.class, componentType=String.class)
    protected Set<String> excludedFields = Collections.emptySet();
    @XNodeMap(value="field", key="@name", type=HashMap.class, componentType=IndexableFieldDescriptor.class)
    protected Map<String, IndexableResourceDataConf> fields;

    public IndexableResourceDescriptor() {
    }

    public IndexableResourceDescriptor(String name, String prefix, boolean allFieldsIndexable, Set<String> excludedFields, Map<String, IndexableResourceDataConf> fields, String type) {
        this.name = name;
        this.prefix = prefix;
        this.allFieldsIndexable = allFieldsIndexable;
        this.excludedFields = excludedFields;
        this.fields = fields;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, IndexableResourceDataConf> getIndexableFields() {
        return this.fields;
    }

    public void setFields(Map<String, IndexableResourceDataConf> fields) {
        this.fields = fields;
    }

    @Override
    public String getPrefix() {
        return this.prefix != null && !this.prefix.equals("") ? this.prefix : this.name;
    }

    public void setPrefix(String schemaPrefix) {
        this.prefix = schemaPrefix;
    }

    @Override
    public boolean areAllFieldsIndexable() {
        return this.allFieldsIndexable;
    }

    public void setAllFieldsIndexable(boolean allFieldsIndexable) {
        this.allFieldsIndexable = allFieldsIndexable;
    }

    @Override
    public Set<String> getExcludedFields() {
        return this.excludedFields;
    }

    public void setExcludedFields(Set<String> excludedFields) {
        this.excludedFields = excludedFields;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return String.format("%s '%s' (type=%s)", this.getClass().getSimpleName(), this.name, this.type);
    }
}

