/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.indexingwrapper;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.search.api.indexingwrapper.DocumentIndexingWrapperFactory;
import org.nuxeo.ecm.core.search.api.indexingwrapper.DocumentModelIndexingWrapperDescriptor;
import org.nuxeo.ecm.core.search.api.indexingwrapper.IndexingWrapperManagerService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class IndexingWrapperManagerComponent
extends DefaultComponent
implements IndexingWrapperManagerService {
    public static final String INDEXINGWRAPPER_FACTORY_EP = "IndexingWrapperFactories";
    private static final Log log = LogFactory.getLog(IndexingWrapperManagerComponent.class);
    protected final Map<String, DocumentIndexingWrapperFactory> wrapperFactories = new HashMap<String, DocumentIndexingWrapperFactory>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (INDEXINGWRAPPER_FACTORY_EP.equals(extensionPoint)) {
            DocumentModelIndexingWrapperDescriptor desc = (DocumentModelIndexingWrapperDescriptor)contribution;
            DocumentIndexingWrapperFactory factory = desc.getNewInstance();
            this.wrapperFactories.put(desc.getTypeName(), factory);
            log.info((Object)("registered new IndexingWrapper for type " + desc.getTypeName()));
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
    }

    @Override
    public DocumentModel getIndexingWrapper(DocumentModel doc) {
        String docType = doc.getType();
        DocumentIndexingWrapperFactory factory = this.wrapperFactories.get(docType);
        if (factory == null) {
            return doc;
        }
        DocumentModel wrapper = factory.getIndexingWrapper(doc);
        if (wrapper == null) {
            return doc;
        }
        return wrapper;
    }
}

