/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.TabActionsSelection;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.ecm.webapp.action.WebActionsLocal;

@Name(value="webActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class WebActionsBean
implements WebActionsLocal,
Serializable {
    private static final long serialVersionUID = 1959221536502251848L;
    private static final Log log = LogFactory.getLog(WebActionsBean.class);
    @In(create=true, required=false)
    protected transient ActionManager actionManager;
    @In(create=true, required=false)
    protected transient ActionContextProvider actionContextProvider;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    protected List<Action> tabsActionsList;
    protected String subTabsCategory;
    protected List<Action> subTabsActionsList;
    protected TabActionsSelection currentTabActions = new TabActionsSelection();

    @Override
    public void initialize() {
        log.debug((Object)"Initializing...");
    }

    @Override
    @Destroy
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    @Override
    @PrePassivate
    public void saveState() {
        log.debug((Object)"PrePassivate");
    }

    @Override
    @PostActivate
    public void readState() {
        log.debug((Object)"PostActivate");
    }

    public List<Action> getActionsList(String category, ActionContext context) {
        ArrayList<Action> list = new ArrayList<Action>();
        List actions = this.actionManager.getActions(category, context);
        if (actions != null) {
            list.addAll(actions);
        }
        return list;
    }

    public List<Action> getActionsList(String category) {
        return this.getActionsList(category, this.createActionContext());
    }

    public List<Action> getUnfiltredActionsList(String category, ActionContext context) {
        ArrayList<Action> list = new ArrayList<Action>();
        List actions = this.actionManager.getActions(category, context, false);
        if (actions != null) {
            list.addAll(actions);
        }
        return list;
    }

    public List<Action> getUnfiltredActionsList(String category) {
        return this.getUnfiltredActionsList(category, this.createActionContext());
    }

    public List<Action> getAllActions(String category) {
        return this.actionManager.getAllActions(category);
    }

    protected ActionContext createActionContext() {
        return this.actionContextProvider.createActionContext();
    }

    protected Action getDefaultTab(String category) {
        if ("VIEW_ACTION_LIST".equals(category)) {
            if (this.getTabsList() == null) {
                return null;
            }
            try {
                return this.tabsActionsList.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (this.subTabsCategory != null && this.subTabsCategory.equals(category)) {
            if (this.getSubTabsList() == null) {
                return null;
            }
            try {
                return this.subTabsActionsList.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        List<Action> actions = this.getActionsList(category, this.createActionContext());
        if (actions != null && actions.size() > 0) {
            return actions.get(0);
        }
        return null;
    }

    public Action getCurrentTabAction(String category) {
        Action action = this.currentTabActions.getCurrentTabAction(category);
        if (action == null) {
            action = this.getDefaultTab(category);
        }
        return action;
    }

    public void setCurrentTabAction(String category, Action tabAction) {
        this.currentTabActions.setCurrentTabAction(category, tabAction);
        if ("VIEW_ACTION_LIST".equals(category)) {
            this.resetSubTabs();
        }
    }

    public Action getCurrentSubTabAction(String parentActionId) {
        return this.getCurrentTabAction(TabActionsSelection.getSubTabCategory((String)parentActionId));
    }

    public String getCurrentTabId(String category) {
        Action action = this.getCurrentTabAction(category);
        if (action != null) {
            return action.getId();
        }
        return null;
    }

    public boolean hasCurrentTabId(String category) {
        return this.currentTabActions.getCurrentTabAction(category) != null;
    }

    public void setCurrentTabId(String category, String tabId, String ... subTabIds) {
        this.currentTabActions.setCurrentTabId(this.actionManager, this.createActionContext(), category, tabId, subTabIds);
        if ("VIEW_ACTION_LIST".equals(category)) {
            this.resetSubTabs();
        }
    }

    public String getCurrentTabIds() {
        return this.currentTabActions.getCurrentTabIds();
    }

    public void setCurrentTabIds(String tabIds) {
        this.currentTabActions.setCurrentTabIds(this.actionManager, this.createActionContext(), tabIds);
        this.resetSubTabs();
    }

    public void resetCurrentTabs() {
        this.currentTabActions.resetCurrentTabs();
    }

    public void resetCurrentTabs(String category) {
        this.currentTabActions.resetCurrentTabs(category);
    }

    public void resetCurrentTab() {
        this.resetCurrentTabs("VIEW_ACTION_LIST");
    }

    protected void resetSubTabs() {
        this.subTabsCategory = null;
        this.subTabsActionsList = null;
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged", "locationSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetTabList() {
        this.tabsActionsList = null;
        this.resetSubTabs();
        this.resetCurrentTab();
    }

    @Factory(value="tabsActionsList", scope=ScopeType.EVENT)
    public List<Action> getTabsList() {
        if (this.tabsActionsList == null) {
            this.tabsActionsList = this.getActionsList("VIEW_ACTION_LIST");
        }
        return this.tabsActionsList;
    }

    @Factory(value="subTabsActionsList", scope=ScopeType.EVENT)
    public List<Action> getSubTabsList() {
        String currentTabId;
        if (this.subTabsActionsList == null && (currentTabId = this.getCurrentTabId()) != null) {
            this.subTabsCategory = TabActionsSelection.getSubTabCategory((String)currentTabId);
            this.subTabsActionsList = this.getActionsList(this.subTabsCategory);
        }
        return this.subTabsActionsList;
    }

    @Factory(value="currentTabAction", scope=ScopeType.EVENT)
    public Action getCurrentTabAction() {
        return this.getCurrentTabAction("VIEW_ACTION_LIST");
    }

    public void setCurrentTabAction(Action currentTabAction) {
        this.setCurrentTabAction("VIEW_ACTION_LIST", currentTabAction);
    }

    @Factory(value="currentSubTabAction", scope=ScopeType.EVENT)
    public Action getCurrentSubTabAction() {
        Action action = this.getCurrentTabAction();
        if (action != null) {
            return this.getCurrentTabAction(TabActionsSelection.getSubTabCategory((String)action.getId()));
        }
        return null;
    }

    public void setCurrentSubTabAction(Action tabAction) {
        if (tabAction != null) {
            String[] categories = tabAction.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot set subtab with id '%s' as this action does not hold any category", tabAction.getId()));
                return;
            }
            if (categories.length != 1) {
                log.error((Object)String.format("Setting subtab with id '%s' with category '%s': use webActions#setCurrentTabAction(action, category) to specify another category", tabAction.getId(), categories[0]));
            }
            this.setCurrentTabAction(categories[0], tabAction);
        }
    }

    public String getCurrentTabId() {
        Action currentTab = this.getCurrentTabAction();
        if (currentTab != null) {
            return currentTab.getId();
        }
        return null;
    }

    public void setCurrentTabId(String tabId) {
        if (tabId != null) {
            this.setCurrentTabId("VIEW_ACTION_LIST", tabId, new String[0]);
        }
    }

    public String getCurrentSubTabId() {
        Action currentSubTab = this.getCurrentSubTabAction();
        if (currentSubTab != null) {
            return currentSubTab.getId();
        }
        return null;
    }

    public void setCurrentSubTabId(String tabId) {
        Action action;
        if (tabId != null && (action = this.getCurrentTabAction()) != null) {
            this.setCurrentTabId(TabActionsSelection.getSubTabCategory((String)action.getId()), tabId, new String[0]);
        }
    }

    public String setCurrentTabAndNavigate(String currentTabActionId) {
        return this.setCurrentTabAndNavigate(this.navigationContext.getCurrentDocument(), currentTabActionId);
    }

    public String setCurrentTabAndNavigate(DocumentModel document, String currentTabActionId) {
        String viewId = null;
        try {
            viewId = this.navigationContext.navigateToDocument(document);
        }
        catch (ClientException e) {
            // empty catch block
        }
        this.getTabsList();
        this.setCurrentTabId(currentTabActionId);
        return viewId;
    }

    @Deprecated
    public List<Action> getSubViewActionsList() {
        return this.getActionsList("SUBVIEW_UPPER_LIST");
    }

    @Deprecated
    public void selectTabAction() {
    }

    @Deprecated
    public String getCurrentLifeCycleState() throws ClientException {
        CoreSession documentManager = (CoreSession)Component.getInstance((String)"documentManager");
        return documentManager.getCurrentLifeCycleState(this.navigationContext.getCurrentDocument().getRef());
    }

    @Deprecated
    public void setTabsList(List<Action> tabsList) {
        this.tabsActionsList = tabsList;
    }

    @Deprecated
    public void setSubTabsList(List<Action> tabsList) {
        this.subTabsActionsList = tabsList;
        this.subTabsCategory = null;
        if (tabsList != null) {
            for (Action action : tabsList) {
                String[] categories;
                if (action == null || (categories = action.getCategories()) == null || categories.length <= 0) continue;
                this.subTabsCategory = categories[0];
                break;
            }
        }
    }

    @Deprecated
    public void setCurrentTabAction(String currentTabActionId) {
        this.setCurrentTabId(currentTabActionId);
    }
}

