/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql;

import java.io.Reader;
import java.io.StringReader;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.parser.Scanner;
import org.nuxeo.ecm.core.query.sql.parser.parser;

public final class SQLQueryParser {
    private SQLQueryParser() {
    }

    public static SQLQuery parse(Reader reader) {
        try {
            Scanner scanner = new Scanner(reader);
            parser parser2 = new parser(scanner);
            return (SQLQuery)parser2.parse().value;
        }
        catch (Exception e) {
            throw new QueryParseException(e);
        }
    }

    public static SQLQuery parse(String string) {
        try {
            SQLQuery query = SQLQueryParser.parse(new StringReader(string));
            query.setQueryString(string);
            return query;
        }
        catch (QueryParseException e) {
            throw new QueryParseException(e.getMessage() + " in query: " + string, (Throwable)((Object)e));
        }
    }

    public static String prepareStringLiteral(String s) {
        return "'" + s.replaceAll("'", "\\\\'") + "'";
    }
}

