/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.GroupByClause;
import org.nuxeo.ecm.core.query.sql.model.HavingClause;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.OperandList;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.ReferenceList;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.SelectList;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;

public class DefaultQueryVisitor
implements IVisitor {
    private static final long serialVersionUID = 1L;

    @Override
    public void visitQuery(SQLQuery node) {
        node.select.accept(this);
        node.from.accept(this);
        if (node.where != null) {
            node.where.accept(this);
        }
        if (node.orderBy != null) {
            node.orderBy.accept(this);
        }
        if (node.groupBy != null) {
            node.groupBy.accept(this);
        }
        if (node.having != null) {
            node.having.accept(this);
        }
    }

    @Override
    public void visitSelectClause(SelectClause node) {
        SelectList elements = node.elements;
        for (int i = 0; i < elements.size(); ++i) {
            ((Operand)elements.get(i)).accept(this);
        }
    }

    @Override
    public void visitFromClause(FromClause node) {
    }

    @Override
    public void visitWhereClause(WhereClause node) {
        node.predicate.accept(this);
    }

    @Override
    public void visitGroupByClause(GroupByClause node) {
    }

    @Override
    public void visitHavingClause(HavingClause node) {
        if (node.predicate != null) {
            node.predicate.accept(this);
        }
    }

    @Override
    public void visitOrderByClause(OrderByClause node) {
        node.elements.accept(this);
    }

    @Override
    public void visitOrderByList(OrderByList node) {
        for (OrderByExpr aNode : node) {
            aNode.accept(this);
        }
    }

    @Override
    public void visitOrderByExpr(OrderByExpr node) {
        node.reference.accept(this);
    }

    @Override
    public void visitExpression(Expression node) {
        if (node.rvalue == null) {
            if (node.isSuffix()) {
                node.lvalue.accept(this);
                node.operator.accept(this);
            } else {
                node.operator.accept(this);
                node.lvalue.accept(this);
            }
        } else {
            node.lvalue.accept(this);
            node.operator.accept(this);
            node.rvalue.accept(this);
        }
    }

    @Override
    public void visitMultiExpression(MultiExpression node) {
        for (Operand operand : node.values) {
            operand.accept(this);
        }
    }

    @Override
    public void visitOperator(Operator node) {
    }

    @Override
    public void visitReference(Reference node) {
    }

    @Override
    public void visitReferenceList(ReferenceList node) {
        for (Reference reference : node) {
            reference.accept(this);
        }
    }

    @Override
    public void visitLiteral(Literal node) {
    }

    @Override
    public void visitLiteralList(LiteralList node) {
        for (Literal literal : node) {
            literal.accept(this);
        }
    }

    @Override
    public void visitDateLiteral(DateLiteral node) {
        this.visitLiteral(node);
    }

    @Override
    public void visitStringLiteral(StringLiteral node) {
        this.visitLiteral(node);
    }

    @Override
    public void visitDoubleLiteral(DoubleLiteral node) {
        this.visitLiteral(node);
    }

    @Override
    public void visitIntegerLiteral(IntegerLiteral node) {
        this.visitLiteral(node);
    }

    @Override
    public void visitFunction(Function node) {
        for (Operand operand : node.args) {
            operand.accept(this);
        }
    }

    @Override
    public void visitOperandList(OperandList node) {
        for (Operand operand : node) {
            operand.accept(this);
        }
    }
}

