/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Literal;

public class IntegerLiteral
extends Literal {
    private static final long serialVersionUID = 4769705314623462546L;
    public final long value;

    public IntegerLiteral(long value) {
        this.value = value;
    }

    public IntegerLiteral(Long value) {
        this.value = value;
    }

    public IntegerLiteral(Integer value) {
        this.value = value.intValue();
    }

    public IntegerLiteral(String value) {
        this.value = Long.parseLong(value);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitIntegerLiteral(this);
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntegerLiteral) {
            return this.value == ((IntegerLiteral)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }
}

