/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.plugins;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class AnonymousAuthenticator
implements NuxeoAuthenticationPlugin,
NuxeoAuthenticationPluginLogoutExtension {
    private static final Log log = LogFactory.getLog(AnonymousAuthenticator.class);
    public static final String BLOCK_ANONYMOUS_LOGIN_KEY = "org.nuxeo.ecm.platform.ui.web.auth.anonymous.block";
    protected boolean initialized;
    protected String anonymousLogin;

    public static boolean isAnonymousRequest(HttpServletRequest httpRequest) {
        Principal user = httpRequest.getUserPrincipal();
        if (user != null && user instanceof NuxeoPrincipal) {
            return ((NuxeoPrincipal)user).isAnonymous();
        }
        return false;
    }

    @Override
    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (!this.initialized) {
            try {
                this.anonymousLogin = ((UserManager)Framework.getService(UserManager.class)).getAnonymousUserId();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            this.initialized = true;
        }
        if (this.anonymousLogin == null) {
            return null;
        }
        if (this.isAnonymousLoginBlocked(httpRequest)) {
            return null;
        }
        return new UserIdentificationInfo(this.anonymousLogin, this.anonymousLogin);
    }

    protected boolean isAnonymousLoginBlocked(HttpServletRequest httpRequest) {
        if (Boolean.TRUE.equals(httpRequest.getAttribute(BLOCK_ANONYMOUS_LOGIN_KEY))) {
            httpRequest.removeAttribute(BLOCK_ANONYMOUS_LOGIN_KEY);
            return true;
        }
        HttpSession session = httpRequest.getSession(false);
        return session != null && Boolean.TRUE.equals(session.getAttribute(BLOCK_ANONYMOUS_LOGIN_KEY));
    }

    @Override
    public void initPlugin(Map<String, String> parameters) {
    }

    @Override
    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return Boolean.FALSE;
    }

    @Override
    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    @Override
    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return null;
    }

    @Override
    public Boolean handleLogout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        return Boolean.FALSE;
    }
}

