/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="specificAuthenticationChain")
public class SpecificAuthChainDescriptor {
    @XNode(value="@name")
    protected String name;
    @XNodeList(value="replacementChain/plugin", type=ArrayList.class, componentType=String.class)
    private List<String> replacementChain;
    @XNodeList(value="allowedPlugins/plugin", type=ArrayList.class, componentType=String.class)
    private List<String> allowedPlugins;
    @XNodeList(value="urlPatterns/url", type=ArrayList.class, componentType=String.class)
    private List<String> urls;
    private List<Pattern> urlPatterns;
    @XNodeMap(value="headers/header", key="@name", type=HashMap.class, componentType=String.class)
    private Map<String, String> headers;
    private Map<String, Pattern> headerPatterns;

    public List<String> getReplacementChain() {
        return this.replacementChain;
    }

    public List<String> getAllowedPlugins() {
        return this.allowedPlugins;
    }

    public List<Pattern> getUrlPatterns() {
        if (this.urlPatterns == null) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String url : this.urls) {
                patterns.add(Pattern.compile(url));
            }
            this.urlPatterns = patterns;
        }
        return this.urlPatterns;
    }

    public Map<String, Pattern> getHeaderPatterns() {
        if (this.headerPatterns == null) {
            this.headerPatterns = new HashMap<String, Pattern>();
            for (String headerName : this.headers.keySet()) {
                this.headerPatterns.put(headerName, Pattern.compile(this.headers.get(headerName)));
            }
        }
        return this.headerPatterns;
    }

    public List<String> computeResultingChain(List<String> defaultChain) {
        if (this.replacementChain != null && !this.replacementChain.isEmpty()) {
            return this.replacementChain;
        }
        ArrayList<String> filtredChain = new ArrayList<String>();
        for (String pluginName : defaultChain) {
            if (!this.allowedPlugins.contains(pluginName)) continue;
            filtredChain.add(pluginName);
        }
        return filtredChain;
    }
}

