/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingServletOutputStream;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class DownloadServlet
extends HttpServlet {
    private static final String NXDOWNLOADINFO_PREFIX = "nxdownloadinfo";
    private static final String NXBIGFILE_PREFIX = "nxbigfile";
    protected static final int BUFFER_SIZE = 524288;
    protected static final int MIN_BUFFER_SIZE = 65536;
    private static final long serialVersionUID = 986876871L;
    public static final Log log = LogFactory.getLog(DownloadServlet.class);

    private static CoreSession getCoreSession(String repoName) throws Exception {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repo = rm.getRepository(repoName);
        if (repo == null) {
            throw new ClientException("Unable to get " + repoName + " repository");
        }
        return repo.open();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestURI;
        try {
            requestURI = new URI(req.getRequestURI()).getPath();
        }
        catch (URISyntaxException e1) {
            requestURI = req.getRequestURI();
        }
        if (requestURI.contains("/nxbigfile/")) {
            this.handleDownloadSingleDocument(req, resp, requestURI);
        } else if (requestURI.contains("/nxdownloadinfo/")) {
            this.handleGetDownloadInfo(req, resp, requestURI);
        } else if (requestURI.contains("/nxbigzipfile/")) {
            this.handleDownloadTemporaryZip(req, resp, requestURI);
        }
    }

    private Blob resolveBlob(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        String completePath;
        int idx;
        String[] alternatePath;
        String filePath = requestURI.replace(VirtualHostHelper.getContextPath((ServletRequest)req) + "/" + NXBIGFILE_PREFIX + "/", "");
        String[] pathParts = filePath.split("/");
        String repoName = pathParts[0];
        String docId = pathParts[1];
        String fieldPath = "blobholder:0";
        if (pathParts.length > 2) {
            fieldPath = pathParts[2];
        }
        String fileName = null;
        if (pathParts.length > 3) {
            fileName = pathParts[3];
        }
        if ((alternatePath = filePath.split(docId)).length > 1 && (idx = (completePath = alternatePath[1]).lastIndexOf(47)) > 0) {
            fieldPath = completePath.substring(1, idx);
            fileName = completePath.substring(idx + 1);
        }
        CoreSession session = null;
        try {
            session = DownloadServlet.getCoreSession(repoName);
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docId));
            Blob blob = null;
            if (fieldPath != null) {
                if ((fieldPath = fieldPath.replace(';', ':')).startsWith("blobholder")) {
                    BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
                    if (bh == null) {
                        Blob blob2 = null;
                        return blob2;
                    }
                    String bhPath = fieldPath.replace("blobholder:", "");
                    if ("".equals(bhPath) || "0".equals(bhPath)) {
                        blob = bh.getBlob();
                    } else {
                        int idxbh = Integer.parseInt(bhPath);
                        blob = (Blob)bh.getBlobs().get(idxbh);
                    }
                } else {
                    blob = (Blob)DocumentModelUtils.getPropertyValue((DocumentModel)doc, (String)DocumentModelUtils.decodePropertyName((String)fieldPath));
                    if (blob == null) {
                        blob = (Blob)DocumentModelUtils.getComplexPropertyValue((DocumentModel)doc, (String)fieldPath);
                    }
                }
            }
            if (fileName != null && !fileName.isEmpty()) {
                blob.setFilename(fileName);
            }
            Blob blob3 = blob;
            return blob3;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (session != null) {
                CoreInstance.getInstance().close(session);
            }
        }
    }

    private void handleGetDownloadInfo(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        String downloadUrl = requestURI.replace(NXDOWNLOADINFO_PREFIX, NXBIGFILE_PREFIX);
        Blob blob = this.resolveBlob(req, resp, downloadUrl);
        if (blob == null) {
            try {
                resp.sendError(204, "No Blob found");
                return;
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        StringBuffer sb = new StringBuffer();
        resp.setContentType("text/plain");
        try {
            sb.append(blob.getMimeType());
            sb.append(":");
            sb.append(URLEncoder.encode(blob.getFilename(), "UTF-8"));
            sb.append(":");
            sb.append(VirtualHostHelper.getServerURL((ServletRequest)req));
            sb.append(downloadUrl.substring(1));
            resp.getWriter().write(sb.toString());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void handleDownloadSingleDocument(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        Blob blob = this.resolveBlob(req, resp, requestURI);
        if (blob == null) {
            return;
        }
        try {
            this.downloadBlob(req, resp, blob, null);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void downloadBlob(HttpServletRequest req, HttpServletResponse resp, Blob blob, String fileName) throws IOException, ServletException {
        InputStream in = null;
        try {
            int read;
            if (fileName == null || fileName.length() == 0) {
                fileName = blob.getFilename() != null && blob.getFilename().length() > 0 ? blob.getFilename() : "file";
            }
            boolean inline = req.getParameter("inline") != null;
            String userAgent = req.getHeader("User-Agent");
            String contentDisposition = RFC2231.encodeContentDisposition((String)fileName, (boolean)inline, (String)userAgent);
            resp.setHeader("Content-Disposition", contentDisposition);
            resp.setContentType(blob.getMimeType());
            long fileSize = blob.getLength();
            if (fileSize > 0L && fileSize < Integer.MAX_VALUE) {
                resp.setContentLength((int)fileSize);
            }
            ServletOutputStream out = resp.getOutputStream();
            in = blob.getStream();
            BufferingServletOutputStream.stopBuffering((OutputStream)out);
            byte[] buffer = new byte[524288];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                out.flush();
            }
        }
        catch (IOException ioe) {
            this.handleClientDisconnect(ioe);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (resp != null) {
                try {
                    resp.flushBuffer();
                }
                catch (IOException ioe) {
                    this.handleClientDisconnect(ioe);
                }
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public void handleClientDisconnect(IOException ioe) throws IOException {
        if (!"ClientAbortException".equals(ioe.getClass().getSimpleName())) {
            throw ioe;
        }
        log.debug((Object)ioe, (Throwable)ioe);
    }

    private void handleDownloadTemporaryZip(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws IOException, ServletException {
        String filePath = requestURI.replace(VirtualHostHelper.getContextPath((ServletRequest)req) + "/nxbigzipfile/", "");
        String[] pathParts = filePath.split("/");
        String tmpFileName = pathParts[0];
        File tmpZip = new File(System.getProperty("java.io.tmpdir") + "/" + tmpFileName);
        FileBlob zipBlob = new FileBlob(tmpZip);
        try {
            this.downloadBlob(req, resp, (Blob)zipBlob, "clipboard.zip");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            tmpZip.delete();
        }
    }
}

