/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling.service;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.RequestDumper;

public class DefaultRequestDumper
implements RequestDumper {
    private static final Log log = LogFactory.getLog(DefaultRequestDumper.class);
    protected List<String> attributes = new ArrayList<String>();

    @Override
    public String getDump(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nRequest Attributes:\n\n");
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (this.attributes.contains(name)) continue;
            builder.append(name);
            builder.append(" : ");
            try {
                Object obj = request.getAttribute(name);
                builder.append(obj.toString());
            }
            catch (Exception error) {
                log.error((Object)("ERROR TRYING TO GET THIS REQUEST ATTRIBUTE VALUE: " + name));
                builder.append("ERROR TRYING TO GET THIS REQUEST ATTRIBUTE VALUE");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public void setNotListedAttributes(List<String> attributes) {
        this.attributes = attributes;
    }
}

