/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.dashboard.jsf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="jsfDashboardActions")
@Scope(value=ScopeType.CONVERSATION)
public class JSFDashboardActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONTENT_VIEW_OBSERVER_WORKFLOW_EVENT = "workflowEvent";
    public static final String USER_DOMAINS_CONTENT_VIEW = "user_domains";
    @In(create=true)
    protected ContentViewActions contentViewActions;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected CoreSession documentManager;
    protected DocumentModel selectedDomain;
    protected List<DocumentModel> availableDomains;

    @Factory(value="userDomains", scope=ScopeType.EVENT)
    public List<DocumentModel> getUserDomains() throws ClientException {
        if (this.documentManager == null) {
            return new ArrayList<DocumentModel>();
        }
        if (this.availableDomains == null) {
            ContentView cv = this.contentViewActions.getContentView(USER_DOMAINS_CONTENT_VIEW);
            this.availableDomains = cv.getPageProvider().getCurrentPage();
        }
        return this.availableDomains;
    }

    public DocumentModel getSelectedDomain() throws ClientException {
        List<DocumentModel> domains = this.getUserDomains();
        if (this.selectedDomain == null) {
            DocumentModel currentDomain = this.navigationContext.getCurrentDomain();
            if (currentDomain != null) {
                this.selectedDomain = currentDomain;
            } else if (domains != null && !domains.isEmpty()) {
                this.selectedDomain = domains.get(0);
            }
        } else if (domains != null && !domains.isEmpty() && !domains.contains(this.selectedDomain)) {
            this.selectedDomain = domains.get(0);
        }
        return this.selectedDomain;
    }

    public String getSelectedDomainId() throws ClientException {
        DocumentModel selectedDomain = this.getSelectedDomain();
        if (selectedDomain != null) {
            return selectedDomain.getId();
        }
        return null;
    }

    public void setSelectedDomainId(String selectedDomainId) throws ClientException {
        this.selectedDomain = this.documentManager.getDocument((DocumentRef)new IdRef(selectedDomainId));
    }

    public String getSelectedDomainPath() throws ClientException {
        DocumentModel domain = this.getSelectedDomain();
        if (domain == null) {
            return "";
        }
        return domain.getPathAsString() + "/";
    }

    public String getSelectedDomainTemplatesPath() throws ClientException {
        return this.getSelectedDomainPath() + "templates";
    }

    @Observer(value={"workflowProcessEnded", "workflowNewProcessStarted", "workflowTaskStop", "workflowTaskRejected", "workflowUserAssignmentChanged", "workflowTaskCompleted", "workflowTaskRemoved", "workItemsListLoaded", "workflowTasksComputed", "workflowAbandoned", "workflowProcessCanceled", "documentPublicationRejected", "documentPublicationApproved", "documentPublished"}, create=false)
    public void onWorkflowEvent() {
        this.contentViewActions.refreshOnSeamEvent(CONTENT_VIEW_OBSERVER_WORKFLOW_EVENT);
        this.contentViewActions.resetPageProviderOnSeamEvent(CONTENT_VIEW_OBSERVER_WORKFLOW_EVENT);
    }
}

