/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutRowDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.PropertiesDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;

@XObject(value="layout")
public class LayoutDescriptor
implements LayoutDefinition {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    String name;
    @XNodeMap(value="templates/template", key="@mode", type=HashMap.class, componentType=String.class)
    Map<String, String> templates = new HashMap<String, String>();
    @XNodeList(value="rows/row", type=LayoutRowDescriptor[].class, componentType=LayoutRowDescriptor.class)
    LayoutRowDefinition[] rows = new LayoutRowDefinition[0];
    @XNodeList(value="columns/column", type=LayoutRowDescriptor[].class, componentType=LayoutRowDescriptor.class)
    LayoutRowDefinition[] rowsAsColumns = new LayoutRowDefinition[0];
    @XNodeMap(value="widget", key="@name", type=HashMap.class, componentType=WidgetDescriptor.class)
    Map<String, WidgetDefinition> widgets = new HashMap<String, WidgetDefinition>();
    @XNodeMap(value="properties", key="@mode", type=HashMap.class, componentType=PropertiesDescriptor.class)
    Map<String, PropertiesDescriptor> properties = new HashMap<String, PropertiesDescriptor>();
    Integer columns;

    public String getName() {
        return this.name;
    }

    public String getTemplate(String mode) {
        String template = this.templates.get(mode);
        if (template == null) {
            template = this.templates.get("any");
        }
        return template;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public LayoutRowDefinition[] getRows() {
        if (this.rowsAsColumns != null && this.rowsAsColumns.length > 0) {
            return this.rowsAsColumns;
        }
        return this.rows;
    }

    public int getColumns() {
        if (this.columns == null) {
            LayoutRowDefinition[] rows;
            this.columns = 0;
            for (LayoutRowDefinition def : rows = this.getRows()) {
                int current = def.getWidgets().length;
                if (current <= this.columns) continue;
                this.columns = current;
            }
        }
        return this.columns;
    }

    public WidgetDefinition getWidgetDefinition(String name) {
        return this.widgets.get(name);
    }

    public Map<String, Serializable> getProperties(String layoutMode) {
        return WidgetDescriptor.getProperties(this.properties, layoutMode);
    }

    public Map<String, Map<String, Serializable>> getProperties() {
        return WidgetDescriptor.getProperties(this.properties);
    }
}

