/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.pipeline.inf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.pipeline.inf.InferenceProcessorRDFS;
import org.openjena.riot.pipeline.inf.InferenceSetupRDFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InferenceProcessorTriples
implements Sink<Triple> {
    private final Sink<Triple> output;
    private final InferenceSetupRDFS rdfsSetup;
    private final InferenceProcessorRDFS rdfs;

    public InferenceProcessorTriples(Sink<Triple> output, InferenceSetupRDFS rdfsSetup) {
        this.output = output;
        this.rdfsSetup = rdfsSetup;
        this.rdfs = new InferenceProcessorRDFS(rdfsSetup){

            public void derive(Node s, Node p, Node o) {
                InferenceProcessorTriples.this.output.send(new Triple(s, p, o));
            }
        };
    }

    @Override
    public void send(Triple triple) {
        this.output.send(triple);
        this.rdfs.process(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.output.close();
    }
}

