/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;

public class CompositeTypeImpl
extends ComplexTypeImpl
implements CompositeType {
    private static final long serialVersionUID = 1L;
    protected final Map<String, TypeRef<Schema>> schemas = new HashMap<String, TypeRef<Schema>>();
    protected String[] schemaNames = new String[0];
    protected volatile boolean dirty;
    protected volatile Map<String, Schema> prefix2schemas = Collections.emptyMap();

    public CompositeTypeImpl(CompositeType superType, String schema, String name, String[] schemas) {
        this(superType == null ? null : superType.getRef(), schema, name, schemas);
    }

    public CompositeTypeImpl(TypeRef<? extends CompositeType> superType, String schema, String name, String[] schemas) {
        super((TypeRef<? extends ComplexType>)superType, schema, name);
        CompositeType stype = (CompositeType)this.superType.get();
        if (stype != null) {
            for (String sname : stype.getSchemaNames()) {
                this.addSchema(sname);
            }
        }
        if (schemas != null) {
            for (String sname : schemas) {
                this.addSchema(sname);
            }
        }
    }

    @Override
    public final boolean hasSchemas() {
        return !this.schemas.isEmpty();
    }

    @Override
    public final void addSchema(String schema) {
        this.schemas.put(schema, new TypeRef("@schemas", schema));
        this.updated();
    }

    @Override
    public final void addSchema(Schema schema) {
        this.schemas.put(schema.getName(), schema.getRef());
        this.updated();
    }

    protected void updated() {
        this.schemaNames = this.schemas.keySet().toArray(new String[this.schemas.size()]);
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDirty() {
        if (!this.dirty) {
            return;
        }
        CompositeTypeImpl compositeTypeImpl = this;
        synchronized (compositeTypeImpl) {
            if (!this.dirty) {
                return;
            }
            this.recompute();
            this.dirty = false;
        }
    }

    protected void recompute() {
        HashMap<String, Schema> prefix2schema = new HashMap<String, Schema>();
        HashMap<String, Field> name2field = new HashMap<String, Field>();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (TypeRef<Schema> ref : this.schemas.values()) {
            Schema schema = ref.get();
            if (schema == null) continue;
            prefix2schema.put(schema.getNamespace().prefix, schema);
            for (Field field : schema.getFields()) {
                QName name = field.getName();
                name2field.put(name.getLocalName(), field);
                name2field.put(name.getPrefixedName(), field);
                fields.add(field);
            }
        }
        this.prefix2schemas = prefix2schema;
        this.fieldsByName = name2field;
        this.fieldsCollection = Collections.unmodifiableCollection(fields);
    }

    @Override
    public final Schema getSchema(String name) {
        TypeRef<Schema> ref = this.schemas.get(name);
        return ref == null ? null : ref.get();
    }

    @Override
    public final Schema getSchemaByPrefix(String prefix) {
        this.checkDirty();
        return this.prefix2schemas.get(prefix);
    }

    @Override
    public final boolean hasSchema(String name) {
        return this.schemas.containsKey(name);
    }

    @Override
    public final String[] getSchemaNames() {
        return (String[])this.schemaNames.clone();
    }

    @Override
    public final Collection<Schema> getSchemas() {
        ArrayList<Schema> list = new ArrayList<Schema>(this.schemas.size());
        for (TypeRef<Schema> ref : this.schemas.values()) {
            list.add(ref.get());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public final Field addField(QName name, TypeRef<? extends Type> type) {
        throw new UnsupportedOperationException("Cannot add fields to a composite type since it is a composition of other complex types");
    }

    @Override
    public final Field getField(String name) {
        this.checkDirty();
        return (Field)this.fieldsByName.get(name);
    }

    @Override
    public final Field getField(QName name) {
        this.checkDirty();
        return (Field)this.fieldsByName.get(name.getPrefixedName());
    }

    @Override
    public final boolean hasField(QName name) {
        this.checkDirty();
        return this.fieldsByName.containsKey(name.getPrefixedName());
    }

    @Override
    public final Collection<Field> getFields() {
        this.checkDirty();
        return this.fieldsCollection;
    }

    @Override
    public final boolean isComplexType() {
        return false;
    }

    @Override
    public final boolean isCompositeType() {
        return true;
    }

    @Override
    public final boolean validate(Object object) {
        return true;
    }

    @Override
    public TypeRef<? extends CompositeType> getRef() {
        return new TypeRef<CompositeTypeImpl>(this.schema, this.name, this);
    }
}

