/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.core.listener;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.runtime.api.Framework;

public class DeleteRelationsListener
implements EventListener {
    private RelationManager relationManager;

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docEventContext = (DocumentEventContext)ctx;
            DocumentModel doc = docEventContext.getSourceDocument();
            this.relationManager = this.getRelationManager();
            Resource sourceResource = this.relationManager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)doc, null);
            StatementImpl patternIncoming = new StatementImpl(null, null, (Node)sourceResource);
            List statementList = this.relationManager.getStatements("default", (Statement)patternIncoming);
            this.relationManager.remove("default", statementList);
            StatementImpl patternOutcoming = new StatementImpl((Node)sourceResource, null, null);
            statementList = this.relationManager.getStatements("default", (Statement)patternOutcoming);
            this.relationManager.remove("default", statementList);
        }
    }

    public RelationManager getRelationManager() throws ClientException {
        if (this.relationManager == null) {
            try {
                this.relationManager = (RelationManager)Framework.getService(RelationManager.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return this.relationManager;
    }
}

