/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.AbstractConnectConnector;
import org.nuxeo.connect.connector.CanNotReachConnectServer;
import org.nuxeo.connect.connector.ConnectClientVersionMismatchError;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.ConnectServerResponse;
import org.nuxeo.connect.connector.http.ConnectHttpResponse;
import org.nuxeo.connect.connector.http.ProxyHelper;
import org.nuxeo.connect.data.SubscriptionStatus;

public class ConnectHttpConnector
extends AbstractConnectConnector
implements ConnectConnector {
    public String overrideUrl = null;
    protected static Log log = LogFactory.getLog(ConnectHttpConnector.class);
    protected SubscriptionStatus cachedStatus = null;
    public static final String CONNECT_HTTP_CACHE_MINUTES_PROPERTY = "org.nuxeo.connect.http.cache.duration";
    protected long lastStatusFetchTime;

    @Override
    protected String getBaseUrl() {
        if (this.overrideUrl != null) {
            return this.overrideUrl;
        }
        return super.getBaseUrl();
    }

    @Override
    protected ConnectServerResponse execServerCall(String url, Map<String, String> headers) throws ConnectServerError {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        ProxyHelper.configureProxyIfNeeded(httpClient);
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(true);
        for (String name : headers.keySet()) {
            method.addRequestHeader(name, headers.get(name));
        }
        int rc = 0;
        try {
            rc = httpClient.executeMethod((HttpMethod)method);
            if (rc == 200) {
                return new ConnectHttpResponse(httpClient, (HttpMethod)method);
            }
            String body = method.getResponseBodyAsString();
            if (rc == 401) {
                throw new ConnectSecurityError("Connect server refused authentication (returned 401)");
            }
            try {
                JSONObject obj = new JSONObject(body);
                String message = obj.getString("message");
                String errorClass = obj.getString("errorClass");
                ConnectServerError error = null;
                error = ConnectSecurityError.class.getSimpleName().equals(errorClass) ? new ConnectServerError(message) : (ConnectClientVersionMismatchError.class.getSimpleName().equals(errorClass) ? new ConnectClientVersionMismatchError(message) : new ConnectServerError(message));
                throw error;
            }
            catch (JSONException e) {
                log.error((Object)"Unable to parse error returned by server", (Throwable)e);
                throw new ConnectServerError("Server returned a code " + rc);
            }
        }
        catch (ConnectServerError cse) {
            method.releaseConnection();
            throw cse;
        }
        catch (Throwable t) {
            String exName = t.getClass().getName();
            if (exName.startsWith("java.net")) {
                log.warn((Object)"Connect Server is not reachable");
                throw new CanNotReachConnectServer(t.getMessage(), t);
            }
            method.releaseConnection();
            throw new ConnectServerError("Error during communication with the Nuxeo Connect Server", t);
        }
    }

    protected int httpCacheDurationInMinutes() {
        String cacheInMinutes = NuxeoConnectClient.getProperty(CONNECT_HTTP_CACHE_MINUTES_PROPERTY, "0");
        try {
            return Integer.parseInt(cacheInMinutes);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected boolean useHttpCache() {
        return this.httpCacheDurationInMinutes() > 0;
    }

    @Override
    public SubscriptionStatus getConnectStatus() throws ConnectServerError {
        if (this.useHttpCache() && this.cachedStatus != null && System.currentTimeMillis() - this.lastStatusFetchTime < (long)(this.httpCacheDurationInMinutes() * 60 * 1000)) {
            return this.cachedStatus;
        }
        try {
            SubscriptionStatus status = super.getConnectStatus();
            if (!NuxeoConnectClient.isTestModeSet() && this.useHttpCache()) {
                this.cachedStatus = status;
            }
            this.lastStatusFetchTime = System.currentTimeMillis();
            return status;
        }
        catch (CanNotReachConnectServer e) {
            if (this.cachedStatus != null) {
                return this.cachedStatus;
            }
            throw e;
        }
    }
}

