/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.downloads;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.downloads.LocalDownloadingPackage;

public class ConnectDownloadManagerImpl
implements ConnectDownloadManager {
    protected BlockingQueue<Runnable> pendingDownloadTasks = new ArrayBlockingQueue<Runnable>(10);
    protected ThreadPoolExecutor tpexec = new ThreadPoolExecutor(1, 5, 300L, TimeUnit.SECONDS, this.pendingDownloadTasks, new DaemonThreadFactory());
    protected Map<String, DownloadingPackage> downloadingPackages = new HashMap<String, DownloadingPackage>();

    @Override
    public List<DownloadingPackage> listDownloadingPackages() {
        ArrayList<DownloadingPackage> result = new ArrayList<DownloadingPackage>();
        result.addAll(this.downloadingPackages.values());
        return result;
    }

    @Override
    public DownloadingPackage storeDownloadedBundle(PackageDescriptor descriptor) {
        LocalDownloadingPackage localPackage = new LocalDownloadingPackage(descriptor);
        this.tpexec.execute(localPackage);
        this.downloadingPackages.put(localPackage.getId(), localPackage);
        return localPackage;
    }

    @Override
    public String getDownloadedBundleLocalStorage() {
        String path = NuxeoConnectClient.getHomePath();
        File dir = new File(path = path + "ConnectDownloads/");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return path;
    }

    @Override
    public void removeDownloadingPackage(String packageId) {
        this.downloadingPackages.remove(packageId);
    }

    protected static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final String namePrefix;
        private static final AtomicInteger poolNumber = new AtomicInteger();
        private final AtomicInteger threadNumber = new AtomicInteger();

        public DaemonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "ConnectDownloadThread-" + poolNumber.incrementAndGet() + '-';
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.namePrefix + this.threadNumber.incrementAndGet();
            Thread t = new Thread(this.group, r, name);
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

