/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.downloads;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.identity.SecurityHeaderGenerator;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;

public class LocalDownloadingPackage
extends PackageDescriptor
implements DownloadingPackage,
Runnable {
    protected static final Log log = LogFactory.getLog(LocalDownloadingPackage.class);
    protected boolean completed = false;
    protected File file = null;

    public LocalDownloadingPackage(PackageDescriptor descriptor) {
        this.classifier = descriptor.getClassifier();
        this.description = descriptor.getDescription();
        this.homePage = descriptor.getHomePage();
        this.name = descriptor.getName();
        this.targetPlatforms = descriptor.getTargetPlatforms();
        this.title = descriptor.getTitle();
        this.type = descriptor.getType();
        this.version = descriptor.getVersion();
        this.sourceUrl = ConnectUrlConfig.getDownloadBaseUrl() + descriptor.getSourceUrl();
        this.sourceDigest = descriptor.getSourceDigest();
        this.sourceSize = descriptor.getSourceSize();
    }

    @Override
    public int getState() {
        if (this.completed) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStreamAsFile(InputStream in) throws IOException {
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        String path = cdm.getDownloadedBundleLocalStorage();
        path = path + this.getId();
        this.file = new File(path);
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(this.file);
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    @Override
    public int getDownloadProgress() {
        if (this.file == null || !this.file.exists()) {
            return 0;
        }
        if (this.getSourceSize() == 0L) {
            return 0;
        }
        return (int)(this.file.length() * 100L / this.getSourceSize());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isDigestOk() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        GetMethod method = new GetMethod(this.sourceUrl);
        method.setFollowRedirects(true);
        try {
            if (!this.sourceUrl.contains("127.0.0.1:8082/test")) {
                Map<String, String> headers = SecurityHeaderGenerator.getHeaders();
                for (String name : headers.keySet()) {
                    method.addRequestHeader(name, headers.get(name));
                }
            }
            int rc = 0;
            try {
                rc = httpClient.executeMethod((HttpMethod)method);
                if (rc == 200) {
                    Header clheader;
                    if (this.sourceSize == 0L && (clheader = method.getResponseHeader("content-length")) != null) {
                        this.sourceSize = Long.parseLong(clheader.getValue());
                    }
                    InputStream in = method.getResponseBodyAsStream();
                    this.saveStreamAsFile(in);
                    this.completed = true;
                    this.registerDownloadedPackage();
                    ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
                    cdm.removeDownloadingPackage(this.getId());
                }
            }
            catch (Exception e) {
                throw new ConnectServerError("Error during communication with the Nuxeo Connect Server", e);
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (Exception exception) {
        }
        finally {
            method.releaseConnection();
        }
    }

    protected void registerDownloadedPackage() {
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        if (pus == null) {
            if (!NuxeoConnectClient.isTestModeSet()) {
                log.error((Object)"Unable to locate PackageUpdateService ... exiting");
            }
            return;
        }
        try {
            pus.addPackage(this.file);
        }
        catch (PackageException e) {
            log.error((Object)"Unable when adding package to PackageUpdateService ... exiting", (Throwable)e);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }
}

