/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

public class Version
implements Comparable<Version> {
    public static final Version ZERO = new Version(0);
    protected int major;
    protected int minor;
    protected int patch;
    protected String classifier;

    public Version(String version) {
        int p = version.lastIndexOf(45);
        if (p > 0) {
            this.classifier = version.substring(p + 1);
            version = version.substring(0, p);
        }
        if ((p = version.indexOf(46, 0)) > -1) {
            this.major = Integer.parseInt(version.substring(0, p));
            int q = version.indexOf(46, p + 1);
            if (q > -1) {
                this.minor = Integer.parseInt(version.substring(p + 1, q));
                this.patch = Integer.parseInt(version.substring(q + 1));
            } else {
                this.minor = Integer.parseInt(version.substring(p + 1));
            }
        } else {
            this.major = Integer.parseInt(version);
        }
    }

    public Version(int major) {
        this(major, 0, 0);
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, null);
    }

    public Version(int major, int minor, int patch, String classifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.classifier = classifier;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String classifier() {
        return this.classifier;
    }

    public boolean lessThan(Version v) {
        return this.compareTo(v) < 0;
    }

    public boolean lessOrEqualsThan(Version v) {
        return this.compareTo(v) <= 0;
    }

    public boolean equalsTo(Version v) {
        return this.compareTo(v) == 0;
    }

    public boolean greaterThan(Version v) {
        return this.compareTo(v) > 0;
    }

    public boolean greaterOrEqualThan(Version v) {
        return this.compareTo(v) >= 0;
    }

    @Override
    public int compareTo(Version o) {
        int d = this.major - o.major;
        if (d != 0) {
            return d;
        }
        d = this.minor - o.minor;
        if (d != 0) {
            return d;
        }
        d = this.patch - o.patch;
        if (d != 0) {
            return d;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Version) {
            Version v = (Version)obj;
            return v.major == this.major && v.minor == this.minor && v.patch == this.patch;
        }
        return false;
    }

    public int hashCode() {
        return this.major << 16 | this.minor << 8 | this.patch;
    }

    public String toString() {
        if (this.classifier == null) {
            return this.major + "." + this.minor + "." + this.patch;
        }
        return this.major + "." + this.minor + "." + this.patch + "-" + this.classifier;
    }

    public static void main(String[] args) {
        System.out.println(new Version("1.0-SNAPSHOT"));
        System.out.println(new Version("1-SNAPSHOT"));
        System.out.println(new Version("1.0.0-SNAPSHOT"));
    }
}

