/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.jbpm.dashboard.DashBoardItemImpl;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.runtime.api.Framework;

public class UserTaskPageProvider
extends AbstractPageProvider<DashBoardItem>
implements PageProvider<DashBoardItem> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserTaskPageProvider.class);
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String FILTER_DOCS_FROM_TRASH = "filterDocumentsFromTrash";
    protected List<DashBoardItem> userTasks;
    protected List<DashBoardItem> pageTasks;

    public List<DashBoardItem> getCurrentPage() {
        if (this.pageTasks == null) {
            this.pageTasks = new ArrayList<DashBoardItem>();
            if (this.userTasks == null) {
                this.getAllTasks();
            }
            if (!this.hasError()) {
                this.resultsCount = this.userTasks.size();
                long pageSize = this.getMinMaxPageSize();
                if (pageSize == 0L) {
                    this.pageTasks.addAll(this.userTasks);
                } else if (this.offset <= this.resultsCount) {
                    int i = Long.valueOf(this.offset).intValue();
                    while ((long)i < this.resultsCount && (long)i < this.offset + pageSize) {
                        this.pageTasks.add(this.userTasks.get(i));
                        ++i;
                    }
                }
            }
        }
        return this.pageTasks;
    }

    protected void getAllTasks() {
        this.error = null;
        this.errorMessage = null;
        this.userTasks = new ArrayList<DashBoardItem>();
        try {
            CoreSession coreSession = this.getCoreSession();
            boolean filterTrashDocs = this.getFilterDocumentsInTrash();
            NuxeoPrincipal pal = (NuxeoPrincipal)coreSession.getPrincipal();
            JbpmService jbpmService = (JbpmService)Framework.getService(JbpmService.class);
            List<TaskInstance> tasks = jbpmService.getCurrentTaskInstances(pal, null);
            if (tasks != null) {
                for (TaskInstance task : tasks) {
                    try {
                        if (task.hasEnded() || task.isCancelled()) continue;
                        DocumentModel doc = jbpmService.getDocumentModel(task, pal);
                        if (doc != null) {
                            if (filterTrashDocs && "deleted".equals(doc.getCurrentLifeCycleState())) continue;
                            this.userTasks.add(new DashBoardItemImpl(task, doc));
                            continue;
                        }
                        log.warn((Object)String.format("User '%s' has a task of type '%s' on a missing or deleted document", pal.getName(), task.getName()));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.error = e;
            this.errorMessage = e.getMessage();
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean getFilterDocumentsInTrash() {
        Map props = this.getProperties();
        if (props.containsKey(FILTER_DOCS_FROM_TRASH)) {
            return Boolean.TRUE.equals(Boolean.valueOf((String)props.get(FILTER_DOCS_FROM_TRASH)));
        }
        return true;
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new ClientRuntimeException("cannot find core session");
        }
        return coreSession;
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        super.pageChanged();
        this.pageTasks = null;
    }

    public void refresh() {
        super.refresh();
        this.userTasks = null;
        this.pageTasks = null;
    }
}

