/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryEntryType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeContainer;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort")
public class RepositoryService
extends AbstractService
implements RepositoryServicePort {
    @Resource
    WebServiceContext wsContext;

    public List<CmisRepositoryEntryType> getRepositories(CmisExtensionType extension) throws CmisException {
        ArrayList<CmisRepositoryEntryType> arrayList;
        List infoDataList;
        CmisService service;
        block6: {
            service = null;
            service = this.getService(this.wsContext, null);
            infoDataList = service.getRepositoryInfos(Converter.convert((CmisExtensionType)extension));
            if (infoDataList != null) break block6;
            List<CmisRepositoryEntryType> list = null;
            this.closeService(service);
            return list;
        }
        try {
            ArrayList<CmisRepositoryEntryType> result = new ArrayList<CmisRepositoryEntryType>();
            for (RepositoryInfo infoData : infoDataList) {
                CmisRepositoryEntryType entry = new CmisRepositoryEntryType();
                entry.setRepositoryId(infoData.getId());
                entry.setRepositoryName(infoData.getName());
                result.add(entry);
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public CmisRepositoryInfoType getRepositoryInfo(String repositoryId, CmisExtensionType extension) throws CmisException {
        CmisRepositoryInfoType cmisRepositoryInfoType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisRepositoryInfoType = Converter.convert((RepositoryInfo)service.getRepositoryInfo(repositoryId, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisRepositoryInfoType;
    }

    public CmisTypeDefinitionListType getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        CmisTypeDefinitionListType cmisTypeDefinitionListType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisTypeDefinitionListType = Converter.convert((TypeDefinitionList)service.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisTypeDefinitionListType;
    }

    public CmisTypeDefinitionType getTypeDefinition(String repositoryId, String typeId, CmisExtensionType extension) throws CmisException {
        CmisTypeDefinitionType cmisTypeDefinitionType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisTypeDefinitionType = Converter.convert((TypeDefinition)service.getTypeDefinition(repositoryId, typeId, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisTypeDefinitionType;
    }

    public List<CmisTypeContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisTypeContainer> arrayList;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ArrayList<CmisTypeContainer> result = new ArrayList<CmisTypeContainer>();
            Converter.convertTypeContainerList((List)service.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, Converter.convert((CmisExtensionType)extension)), result);
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }
}

