/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.runtime.api.Framework;

public class FancyNavigationHandler
extends NavigationHandler {
    private static final Log log = LogFactory.getLog(FancyNavigationHandler.class);
    private final NavigationHandler baseNavigationHandler;

    public FancyNavigationHandler(NavigationHandler navigationHandler) {
        this.baseNavigationHandler = navigationHandler;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        boolean ajaxRequest;
        ExternalContext eContext = context.getExternalContext();
        HttpServletRequest httpRequest = (HttpServletRequest)eContext.getRequest();
        httpRequest.setAttribute("PostOutcome", (Object)outcome);
        try {
            URLPolicyService pservice = (URLPolicyService)Framework.getService(URLPolicyService.class);
            pservice.appendParametersToRequest(context);
        }
        catch (Exception e) {
            log.error((Object)"error occured while appending params to request: ", (Throwable)e);
        }
        this.baseNavigationHandler.handleNavigation(context, fromAction, outcome);
        Map map = eContext.getRequestParameterMap();
        boolean bl = ajaxRequest = map != null && map.containsKey("AJAXREQUEST");
        if (outcome == null && !ajaxRequest && !context.getResponseComplete()) {
            String url = httpRequest.getRequestURL().toString();
            String localUrl = BaseURL.getServerURL((ServletRequest)httpRequest, true);
            String baseUrl = BaseURL.getServerURL((ServletRequest)httpRequest, false);
            if (localUrl != null && !localUrl.equals(baseUrl)) {
                url = url.replaceFirst(localUrl, baseUrl);
            }
            if (Contexts.isEventContextActive()) {
                url = RestHelper.addMainConversationParameters(url);
            }
            try {
                eContext.redirect(url);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

