/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.localconfiguration.theme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.themes.ThemeManager;

@Name(value="themeConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class ThemeConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ThemeConfigurationActions.class);
    protected String theme;

    public List<SelectItem> getAvailableThemes() {
        ArrayList<SelectItem> themes = new ArrayList<SelectItem>();
        for (String theme : ThemeManager.getThemeNames((String)"jsf-facelets")) {
            themes.add(new SelectItem((Object)theme, theme));
        }
        return themes;
    }

    public List<SelectItem> getAvailablePages() {
        ArrayList<SelectItem> pages = new ArrayList<SelectItem>();
        if (this.theme != null && !this.theme.equals("")) {
            for (String pageName : Manager.getThemeManager().getPageNames(this.theme)) {
                pages.add(new SelectItem((Object)pageName, pageName));
            }
        }
        return pages;
    }

    public List<SelectItem> getAvailablePerspectives() {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        for (PerspectiveType perspectiveType : PerspectiveManager.listPerspectives()) {
            selectItemList.add(new SelectItem((Object)perspectiveType.name, perspectiveType.title));
        }
        return selectItemList;
    }

    public List<SelectItem> getAvailableEngines() {
        ArrayList<SelectItem> engines = new ArrayList<SelectItem>();
        return engines;
    }

    public void themeChange(ActionEvent event) {
        UIComponent select = event.getComponent().getParent();
        if (!(select instanceof ValueHolder)) {
            log.error((Object)("Bad component returned " + select));
            throw new AbortProcessingException("Bad component returned " + select);
        }
        this.theme = (String)((ValueHolder)select).getValue();
    }
}

