/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.annotation.factory;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.annotation.factory.AnnotationValidationException;
import org.jboss.annotation.factory.AnnotationValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAnnotationValidator
implements AnnotationValidator {
    @Override
    public void validate(Map<String, Object> map, Class<?> annotation) {
        ArrayList<String> notAssignedAttributes = null;
        Method[] methods = this.getDeclaredMethods(annotation);
        for (int i = 0; i < methods.length; ++i) {
            if (map.get(methods[i].getName()) != null) continue;
            if (notAssignedAttributes == null) {
                notAssignedAttributes = new ArrayList<String>();
            }
            notAssignedAttributes.add(methods[i].getName());
        }
        if (notAssignedAttributes != null) {
            throw new AnnotationValidationException("Unable to fill in default attributes for " + annotation + " " + notAssignedAttributes);
        }
    }

    private Method[] getDeclaredMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }
}

