/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.util;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.util.JSonDocumentExporter;

public class GWTHelper {
    private GWTHelper() {
    }

    public static String toJSon(DocumentModel doc) {
        return GWTHelper.doc2JSon(doc).toString();
    }

    public static JSONArray getChildren(CoreSession session) {
        try {
            return GWTHelper.getChildren(session, session.getRootDocument(), null);
        }
        catch (ClientException e) {
            throw WebException.wrap(e);
        }
    }

    public static JSONArray getChildren(CoreSession session, DocumentRef docRef) {
        return GWTHelper.getChildren(session, docRef, docRef.reference().toString());
    }

    public static JSONArray getChildren(CoreSession session, DocumentRef docRef, String parentRef) {
        try {
            return GWTHelper.getChildren(session, session.getDocument(docRef));
        }
        catch (ClientException e) {
            throw WebException.wrap(e);
        }
    }

    public static JSONArray getChildren(CoreSession session, DocumentModel doc) {
        return GWTHelper.getChildren(session, doc, doc.getId());
    }

    public static JSONArray getChildren(CoreSession session, DocumentModel doc, String parentRef) {
        JSONArray list = new JSONArray();
        if (doc == null) {
            return list;
        }
        try {
            DocumentModelList docs = session.getChildren(doc.getRef());
            for (DocumentModel d : docs) {
                JSONObject o = new JSONObject();
                o.put((Object)"id", (Object)d.getId());
                o.put((Object)"parentId", (Object)parentRef);
                o.put((Object)"name", (Object)d.getName());
                o.put((Object)"path", (Object)d.getPathAsString());
                o.put((Object)"type", (Object)d.getType());
                o.put((Object)"title", (Object)d.getTitle());
                o.put((Object)"isFolder", (Object)d.hasFacet("Folderish"));
                list.add((Object)o);
            }
        }
        catch (ClientException e) {
            throw WebException.wrap(e);
        }
        return list;
    }

    public static JSONArray getChildrenFiles(CoreSession session, DocumentRef docRef, String parentRef) {
        try {
            return GWTHelper.getChildrenFiles(session, session.getDocument(docRef), parentRef);
        }
        catch (ClientException e) {
            throw WebException.wrap(e);
        }
    }

    public static JSONArray getChildrenFiles(CoreSession session, DocumentModel doc, String parentRef) {
        JSONArray list = new JSONArray();
        if (doc == null) {
            return list;
        }
        try {
            DocumentModelList docs = session.getChildren(doc.getRef());
            for (DocumentModel d : docs) {
                if (d.isFolder()) continue;
                JSONObject o = new JSONObject();
                o.put((Object)"id", (Object)d.getId());
                o.put((Object)"name", (Object)d.getName());
                o.put((Object)"path", (Object)d.getPathAsString());
                o.put((Object)"type", (Object)d.getType());
                o.put((Object)"title", (Object)d.getTitle());
                o.put((Object)"parentId", (Object)parentRef);
                o.put((Object)"isFolder", (Object)d.hasFacet("Folderish"));
                list.add((Object)o);
            }
        }
        catch (ClientException e) {
            throw WebException.wrap(e);
        }
        return list;
    }

    public static JSONArray getChildrenFolders(CoreSession session, DocumentRef docRef, String parentRef) {
        try {
            return GWTHelper.getChildrenFolders(session, session.getDocument(docRef), parentRef);
        }
        catch (ClientException e) {
            throw WebException.wrap(e);
        }
    }

    public static JSONArray getChildrenFolders(CoreSession session, DocumentModel doc, String parentRef) {
        JSONArray list = new JSONArray();
        if (doc == null) {
            return list;
        }
        try {
            DocumentModelList docs = session.getChildren(doc.getRef());
            for (DocumentModel d : docs) {
                if (!d.isFolder()) continue;
                JSONObject o = new JSONObject();
                o.put((Object)"id", (Object)d.getId());
                o.put((Object)"parentId", (Object)parentRef);
                o.put((Object)"name", (Object)d.getName());
                o.put((Object)"path", (Object)d.getPathAsString());
                o.put((Object)"type", (Object)d.getType());
                o.put((Object)"title", (Object)d.getTitle());
                o.put((Object)"isFolder", (Object)d.hasFacet("Folderish"));
                list.add((Object)o);
            }
        }
        catch (ClientException e) {
            throw WebException.wrap(e);
        }
        return list;
    }

    public static String toJSon(DocumentModel doc, String ... schemas) {
        return GWTHelper.doc2JSon(doc).toString();
    }

    public static JSONObject doc2JSon(DocumentModel doc) {
        return GWTHelper.doc2JSon(doc, null);
    }

    public static JSONObject doc2JSon(DocumentModel doc, String ... schemas) {
        try {
            DocumentRef parentRef = doc.getParentRef();
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)doc.getId());
            obj.put((Object)"parentId", parentRef == null ? null : parentRef.reference());
            obj.put((Object)"name", (Object)doc.getName());
            obj.put((Object)"path", (Object)doc.getPathAsString());
            obj.put((Object)"isLocked", (Object)doc.isLocked());
            obj.put((Object)"lifeCycleState", (Object)doc.getCurrentLifeCycleState());
            obj.put((Object)"lifeCyclePolicy", (Object)doc.getLifeCyclePolicy());
            obj.put((Object)"type", (Object)doc.getType());
            obj.put((Object)"isVersion", (Object)doc.isVersion());
            obj.put((Object)"isProxy", (Object)doc.isProxy());
            obj.put((Object)"sourceId", (Object)doc.getSourceId());
            obj.put((Object)"facets", (Object)doc.getFacets());
            obj.put((Object)"schemas", (Object)doc.getSchemas());
            JSonDocumentExporter jde = new JSonDocumentExporter();
            if (schemas != null) {
                for (String schema : schemas) {
                    obj.put((Object)schema, (Object)jde.run(doc.getPart(schema)));
                }
            } else {
                for (DocumentPart part : doc.getParts()) {
                    obj.put((Object)part.getName(), (Object)jde.run(part));
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw WebException.wrap("Failed to export documnt as json: " + doc.getPath(), e);
        }
    }
}

