/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.platform.picture.api.adapters.DefaultPictureAdapter;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.picture.config.PictureConfigurationService;
import org.nuxeo.runtime.api.Framework;

public class PictureResourceAdapterFactory
implements DocumentAdapterFactory {
    private static PictureConfigurationService configService;
    private static final Log log;

    private static PictureConfigurationService getConfigService() {
        if (configService == null) {
            configService = (PictureConfigurationService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.picture.config.PictureConfigurationService"));
        }
        return configService;
    }

    public Object getAdapter(DocumentModel doc, Class cls) {
        PictureResourceAdapter adapter = null;
        try {
            PictureResourceAdapterFactory.getConfigService();
            adapter = PictureConfigurationService.getAdapterForType(doc.getType());
        }
        catch (InstantiationException e) {
            log.error((Object)("Error while getting PICTURE adapter for type " + doc.getType() + ':' + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Error while getting PICTURE adapter for type " + doc.getType() + ':' + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("Error while getting PICTUREAdapter Configuration Service:" + e.getMessage()));
        }
        if (adapter == null) {
            adapter = new DefaultPictureAdapter();
        }
        adapter.setDocumentModel(doc);
        return adapter;
    }

    static {
        log = LogFactory.getLog(PictureResourceAdapterFactory.class);
    }
}

