/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;

public abstract class AbstractGroupsPageProvider
extends AbstractPageProvider<DocumentModel>
implements PageProvider<DocumentModel> {
    private static final Log log = LogFactory.getLog(AbstractGroupsPageProvider.class);
    private static final long serialVersionUID = 1L;
    protected static final String GROUPS_LISTING_MODE_PROPERTY = "groupsListingMode";
    protected static final String ALL_MODE = "all";
    protected static final String SEARCH_ONLY_MODE = "search_only";
    protected static final String SEARCH_OVERFLOW_ERROR_MESSAGE = "label.security.searchOverFlow";
    protected List<DocumentModel> pageGroups;

    protected abstract List<DocumentModel> searchAllGroups() throws Exception;

    protected abstract List<DocumentModel> searchGroups() throws Exception;

    public List<DocumentModel> getCurrentPage() {
        if (this.pageGroups == null) {
            this.error = null;
            this.errorMessage = null;
            this.pageGroups = new ArrayList<DocumentModel>();
            List<Object> groups = new ArrayList();
            try {
                String groupListingMode = this.getGroupListingMode();
                if (ALL_MODE.equals(groupListingMode)) {
                    groups = this.searchAllGroups();
                } else if (SEARCH_ONLY_MODE.equals(groupListingMode)) {
                    groups = this.searchGroups();
                }
            }
            catch (SizeLimitExceededException slee) {
                this.error = slee;
                this.errorMessage = SEARCH_OVERFLOW_ERROR_MESSAGE;
                log.warn((Object)slee.getMessage(), (Throwable)slee);
            }
            catch (Exception e) {
                this.error = e;
                this.errorMessage = e.getMessage();
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            if (!this.hasError()) {
                this.resultsCount = groups.size();
                long pageSize = this.getMinMaxPageSize();
                if (pageSize == 0L) {
                    this.pageGroups.addAll(groups);
                } else if (this.offset <= this.resultsCount) {
                    int i = Long.valueOf(this.offset).intValue();
                    while ((long)i < this.resultsCount && (long)i < this.offset + pageSize) {
                        this.pageGroups.add((DocumentModel)groups.get(i));
                        ++i;
                    }
                }
            }
        }
        return this.pageGroups;
    }

    protected String getGroupListingMode() {
        Map props = this.getProperties();
        if (props.containsKey(GROUPS_LISTING_MODE_PROPERTY)) {
            return (String)props.get(GROUPS_LISTING_MODE_PROPERTY);
        }
        return SEARCH_ONLY_MODE;
    }

    protected String getFirstParameter() {
        String param;
        Object[] parameters = this.getParameters();
        if (parameters.length > 0 && (param = (String)parameters[0]) != null) {
            return param.trim();
        }
        return "";
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        super.pageChanged();
        this.pageGroups = null;
    }

    public void refresh() {
        super.refresh();
        this.pageGroups = null;
    }
}

