/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.FragmentGroup;
import org.nuxeo.ecm.core.storage.sql.FragmentsMap;
import org.nuxeo.ecm.core.storage.sql.FulltextParser;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.runtime.api.Framework;

public class SessionImpl
implements Session,
XAResource {
    private static final Log log = LogFactory.getLog(SessionImpl.class);
    private final RepositoryImpl repository;
    private final Mapper mapper;
    private final Model model;
    private final EventProducer eventProducer;
    protected final FulltextParser fulltextParser;
    public final PersistenceContext context;
    private boolean live;
    private boolean inTransaction;
    private Node rootNode;
    private long threadId;
    private boolean readAclsChanged;
    private String threadName;

    public SessionImpl(RepositoryImpl repository, Model model, Mapper mapper, Credentials credentials) throws StorageException {
        this.repository = repository;
        this.mapper = mapper;
        ((CachingMapper)mapper).setSession(this);
        this.model = model;
        this.context = new PersistenceContext(model, mapper, this);
        this.live = true;
        this.readAclsChanged = false;
        try {
            this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            throw new StorageException("Unable to find EventProducer", e);
        }
        try {
            this.fulltextParser = repository.fulltextParserClass.newInstance();
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        this.computeRootNode();
    }

    private void checkLive() {
        if (!this.live) {
            throw new IllegalStateException("Session is not live");
        }
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    public XAResource getXAResource() {
        return this;
    }

    protected int clearCaches() {
        if (this.inTransaction) {
            return 0;
        }
        this.checkThreadEnd();
        return this.context.clearCaches();
    }

    protected void rollback() {
        this.context.clearCaches();
    }

    protected void checkThread() {
        if (this.threadId == 0L) {
            return;
        }
        long currentThreadId = Thread.currentThread().getId();
        if (this.threadId == currentThreadId) {
            return;
        }
        String currentThreadName = Thread.currentThread().getName();
        String msg = String.format("Concurrency Error: Session was started in thread %s (%s) but is being used in thread %s (%s)", this.threadId, this.threadName, currentThreadId, currentThreadName);
        log.debug((Object)msg, (Throwable)new Exception(msg));
    }

    protected void checkThreadStart() {
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
    }

    protected void checkThreadEnd() {
        this.threadId = 0L;
    }

    protected Serializable generateNewId(Serializable id) {
        return this.context.generateNewId(id);
    }

    protected boolean isIdNew(Serializable id) {
        return this.context.isIdNew(id);
    }

    public void close() throws ResourceException {
        try {
            this.closeSession();
        }
        catch (StorageException e) {
            throw new ResourceException((Throwable)((Object)e));
        }
        this.repository.closeSession(this);
    }

    protected void closeSession() throws StorageException {
        this.live = false;
        this.mapper.close();
    }

    public Interaction createInteraction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    @Override
    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Node getRootNode() {
        this.checkThread();
        this.checkLive();
        return this.rootNode;
    }

    @Override
    public Binary getBinary(InputStream in) throws StorageException {
        try {
            return this.repository.getBinaryManager().getBinary(in);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void save() throws StorageException {
        this.checkLive();
        this.flush();
        if (!this.inTransaction) {
            this.sendInvalidationsToOthers();
            this.processReceivedInvalidations();
        }
    }

    protected void flush() throws StorageException {
        this.checkThread();
        if (!this.repository.getRepositoryDescriptor().fulltextDisabled) {
            this.updateFulltext();
        }
        this.flushWithoutFulltext();
        this.checkInvalidationsConflict();
    }

    protected void flushWithoutFulltext() throws StorageException {
        RowMapper.RowBatch batch = this.context.getSaveBatch();
        if (!batch.isEmpty() || this.readAclsChanged) {
            log.debug((Object)"Saving session");
            if (!batch.isEmpty()) {
                this.mapper.write(batch);
            }
            if (this.readAclsChanged) {
                this.updateReadAcls();
            }
            log.debug((Object)"End of save");
        }
    }

    protected Serializable getContainingDocument(Serializable id) throws StorageException {
        return this.context.getContainingDocument(id);
    }

    protected void updateFulltext() throws StorageException {
        HashSet<Serializable> dirtyStrings = new HashSet<Serializable>();
        HashSet<Serializable> dirtyBinaries = new HashSet<Serializable>();
        this.context.findDirtyDocuments(dirtyStrings, dirtyBinaries);
        if (dirtyStrings.isEmpty() && dirtyBinaries.isEmpty()) {
            return;
        }
        for (Serializable docId : dirtyStrings) {
            if (docId == null) {
                log.error((Object)"Got null doc id in fulltext update, cannot happen");
                continue;
            }
            Node document = this.getNodeById(docId);
            if (document == null) continue;
            String documentType = document.getPrimaryType();
            String[] mixinTypes = document.getMixinTypes();
            this.fulltextParser.setDocument(document, this);
            for (String indexName : this.model.getFulltextInfo().indexNames) {
                Set<String> paths = this.model.getFulltextInfo().indexesAllSimple.contains(indexName) ? this.model.getSimpleTextPropertyPaths(documentType, mixinTypes) : this.model.getFulltextInfo().propPathsByIndexSimple.get(indexName);
                String strings = this.fulltextParser.findFulltext(indexName, paths);
                String propName = "ecm:simpleText" + this.model.getFulltextIndexSuffix(indexName);
                document.setSimpleProperty(propName, (Serializable)((Object)strings));
            }
        }
        this.updateFulltextBinaries(dirtyBinaries);
    }

    protected void updateFulltextBinaries(Set<Serializable> dirtyBinaries) throws StorageException {
        if (dirtyBinaries.isEmpty()) {
            return;
        }
        for (Node node : this.getNodesByIds(new ArrayList<Serializable>(dirtyBinaries))) {
            node.getSimpleProperty("ecm:fulltextJobId").setValue(node.getId());
        }
        log.debug((Object)("Queued documents for asynchronous fulltext extraction: " + dirtyBinaries.size()));
        EventContextImpl eventContext = new EventContextImpl(new Object[]{dirtyBinaries, this.model.getFulltextInfo()});
        eventContext.setRepositoryName(this.getRepositoryName());
        Event event = eventContext.newEvent("event_storage_binaries_doc");
        try {
            this.eventProducer.fireEvent(event);
        }
        catch (ClientException e) {
            throw new StorageException(e);
        }
    }

    protected void sendInvalidationsToOthers() throws StorageException {
        this.context.sendInvalidationsToOthers();
    }

    protected void processReceivedInvalidations() throws StorageException {
        this.context.processReceivedInvalidations();
    }

    protected void checkInvalidationsConflict() throws StorageException {
        this.context.checkInvalidationsConflict();
    }

    protected void collectModified(Invalidations invalidations, Set<String> docs, Set<String> parents) {
        if (invalidations == null || invalidations.modified == null) {
            return;
        }
        for (RowId rowId : invalidations.modified) {
            String docId;
            String id = (String)((Object)rowId.id);
            try {
                docId = (String)((Object)this.getContainingDocument((Serializable)((Object)id)));
            }
            catch (StorageException e) {
                log.error((Object)("Cannot get containing document for: " + id), (Throwable)((Object)e));
                docId = null;
            }
            if (docId == null) continue;
            if ("__PARENT__".equals(rowId.tableName)) {
                if (docId.equals(id)) {
                    parents.add(docId);
                    continue;
                }
                docs.add(docId);
                continue;
            }
            docs.add(docId);
        }
    }

    protected void sendInvalidationEvent(Invalidations invalidations, boolean local) {
        this.sendInvalidationEvent(new Invalidations.InvalidationsPair(invalidations, null));
    }

    protected void sendInvalidationEvent(Invalidations.InvalidationsPair pair) {
        if (!this.repository.repositoryDescriptor.sendInvalidationEvents) {
            return;
        }
        HashSet<String> modifiedDocIds = new HashSet<String>();
        HashSet<String> modifiedParentIds = new HashSet<String>();
        this.collectModified(pair.cacheInvalidations, modifiedDocIds, modifiedParentIds);
        this.collectModified(pair.eventInvalidations, modifiedDocIds, modifiedParentIds);
        if (modifiedDocIds.isEmpty() && modifiedParentIds.isEmpty()) {
            return;
        }
        EventContextImpl ctx = new EventContextImpl(null, null);
        ctx.setRepositoryName(this.repository.getName());
        ctx.setProperty("modifiedDocIds", modifiedDocIds);
        ctx.setProperty("modifiedParentIds", modifiedParentIds);
        EventImpl event = new EventImpl("vcsInvalidations", (EventContext)ctx);
        try {
            this.repository.eventService.fireEvent((Event)event);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to send invalidation event: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    protected Node getNodeById(Serializable id, boolean prefetch) throws StorageException {
        if (this.context.isDeleted(id)) {
            return null;
        }
        List<Node> nodes = this.getNodesByIds(Collections.singletonList(id), prefetch);
        return nodes.get(0);
    }

    @Override
    public Node getNodeById(Serializable id) throws StorageException {
        this.checkThread();
        this.checkLive();
        if (id == null) {
            throw new IllegalArgumentException("Illegal null id");
        }
        return this.getNodeById(id, true);
    }

    public List<Node> getNodesByIds(List<Serializable> ids, boolean prefetch) throws StorageException {
        ArrayList<RowId> hierRowIds = new ArrayList<RowId>(ids.size());
        for (Serializable id : ids) {
            hierRowIds.add(new RowId("hierarchy", id));
        }
        List<Fragment> hierFragments = this.context.getMulti(hierRowIds, false);
        HashMap<Serializable, FragmentGroup> fragmentGroups = new HashMap<Serializable, FragmentGroup>(ids.size());
        for (Fragment fragment : hierFragments) {
            Serializable id = fragment.row.id;
            fragmentGroups.put(id, new FragmentGroup((SimpleFragment)fragment, new FragmentsMap()));
        }
        if (prefetch) {
            ArrayList<RowId> bulkRowIds = new ArrayList<RowId>();
            HashSet<Serializable> proxyIds = new HashSet<Serializable>();
            for (Fragment fragment : hierFragments) {
                this.findPrefetchedFragments((SimpleFragment)fragment, bulkRowIds, proxyIds);
            }
            ArrayList<RowId> proxiesRowIds = new ArrayList<RowId>(proxyIds.size());
            for (Serializable id : proxyIds) {
                proxiesRowIds.add(new RowId("proxies", id));
            }
            List<Fragment> proxiesFragments = this.context.getMulti(proxiesRowIds, true);
            HashSet<Serializable> targetIds = new HashSet<Serializable>();
            for (Fragment fragment : proxiesFragments) {
                Serializable targetId = ((SimpleFragment)fragment).get("targetid");
                targetIds.add(targetId);
            }
            targetIds.removeAll(ids);
            hierRowIds = new ArrayList(targetIds.size());
            for (Serializable id : targetIds) {
                hierRowIds.add(new RowId("hierarchy", id));
            }
            hierFragments = this.context.getMulti(hierRowIds, true);
            for (Fragment fragment : hierFragments) {
                this.findPrefetchedFragments((SimpleFragment)fragment, bulkRowIds, null);
            }
            List<Fragment> fragments = this.context.getMulti(bulkRowIds, true);
            for (Fragment fragment : fragments) {
                FragmentGroup fragmentGroup = (FragmentGroup)fragmentGroups.get(fragment.row.id);
                if (fragmentGroup == null) continue;
                fragmentGroup.fragments.put(fragment.row.tableName, fragment);
            }
        }
        ArrayList<Node> nodes = new ArrayList<Node>(ids.size());
        for (Serializable id : ids) {
            FragmentGroup fragmentGroup = (FragmentGroup)fragmentGroups.get(id);
            Node node = fragmentGroup == null ? null : new Node(this.context, fragmentGroup);
            nodes.add(node);
        }
        return nodes;
    }

    protected void findPrefetchedFragments(SimpleFragment hierFragment, List<RowId> bulkRowIds, Set<Serializable> proxyIds) throws StorageException {
        Serializable id = hierFragment.row.id;
        String typeName = (String)((Object)hierFragment.get("primarytype"));
        if ("ecm:proxy".equals(typeName)) {
            if (proxyIds != null) {
                proxyIds.add(id);
            }
            return;
        }
        Set<String> tableNames = this.model.getTypePrefetchedFragments(typeName);
        if (tableNames == null) {
            return;
        }
        Serializable parentId = hierFragment.get("parentid");
        for (String tableName : tableNames) {
            if ("hierarchy".equals(tableName)) continue;
            if (parentId != null) {
                if ("versions".equals(tableName)) continue;
            }
            bulkRowIds.add(new RowId(tableName, id));
        }
    }

    @Override
    public List<Node> getNodesByIds(List<Serializable> ids) throws StorageException {
        this.checkThread();
        this.checkLive();
        return this.getNodesByIds(ids, true);
    }

    @Override
    public Node getParentNode(Node node) throws StorageException {
        this.checkLive();
        if (node == null) {
            throw new IllegalArgumentException("Illegal null node");
        }
        Serializable id = node.getHierFragment().get("parentid");
        return id == null ? null : this.getNodeById(id);
    }

    @Override
    public String getPath(Node node) throws StorageException {
        this.checkLive();
        LinkedList<String> list = new LinkedList<String>();
        while (node != null) {
            list.add(node.getName());
            node = this.getParentNode(node);
        }
        if (list.size() == 1) {
            String name = (String)list.get(0);
            if (name == null || name.length() == 0) {
                return "/";
            }
            return name;
        }
        Collections.reverse(list);
        return StringUtils.join(list, (String)"/");
    }

    @Override
    public Node getNodeByPath(String path, Node node) throws StorageException {
        int i;
        this.checkLive();
        if (path == null) {
            throw new IllegalArgumentException("Illegal null path");
        }
        if ((path = Normalizer.normalize(path, Normalizer.Form.NFKC)).startsWith("/")) {
            node = this.getRootNode();
            if (path.equals("/")) {
                return node;
            }
            i = 1;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("Illegal relative path with null node: " + path);
            }
            i = 0;
        }
        String[] names = path.split("/", -1);
        while (i < names.length) {
            String name = names[i];
            if (name.length() == 0) {
                throw new IllegalArgumentException("Illegal path with empty component: " + path);
            }
            if ((node = this.getChildNode(node, name, false)) == null) {
                return null;
            }
            ++i;
        }
        return node;
    }

    @Override
    public Node addChildNode(Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        if (pos == null && !complexProp && parent != null) {
            pos = this.context.getNextPos(parent.getId(), complexProp);
        }
        return this.addChildNode(null, parent, name, pos, typeName, complexProp);
    }

    @Override
    public Node addChildNode(Serializable id, Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        this.checkLive();
        if (name == null) {
            throw new IllegalArgumentException("Illegal null name");
        }
        if ((name = Normalizer.normalize(name, Normalizer.Form.NFKC)).contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        if (!this.model.isType(typeName)) {
            throw new IllegalArgumentException("Unknown type: " + typeName);
        }
        id = this.generateNewId(id);
        Serializable parentId = parent == null ? null : parent.hierFragment.getId();
        return this.addNode(id, parentId, name, pos, typeName, complexProp);
    }

    protected Node addNode(Serializable id, Serializable parentId, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        this.requireReadAclsUpdate();
        Row hierRow = new Row("hierarchy", id);
        hierRow.putNew("parentid", parentId);
        hierRow.putNew("name", (Serializable)((Object)name));
        hierRow.putNew("pos", pos);
        hierRow.putNew("primarytype", (Serializable)((Object)typeName));
        hierRow.putNew("isproperty", Boolean.valueOf(complexProp));
        SimpleFragment hierFragment = this.context.createSimpleFragment(hierRow);
        FragmentGroup fragmentGroup = new FragmentGroup(hierFragment, new FragmentsMap());
        return new Node(this.context, fragmentGroup);
    }

    @Override
    public Node addProxy(Serializable targetId, Serializable versionableId, Node parent, String name, Long pos) throws StorageException {
        Node proxy = this.addChildNode(parent, name, pos, "ecm:proxy", false);
        proxy.setSimpleProperty("ecm:proxyTargetId", targetId);
        proxy.setSimpleProperty("ecm:proxyVersionableId", versionableId);
        return proxy;
    }

    @Override
    public boolean hasChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        SimpleFragment fragment = this.context.getChildHierByName(parent.getId(), name, complexProp);
        return fragment != null;
    }

    @Override
    public Node getChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        if (name == null || name.contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        SimpleFragment fragment = this.context.getChildHierByName(parent.getId(), name, complexProp);
        return fragment == null ? null : this.getNodeById(fragment.getId());
    }

    @Override
    public boolean hasChildren(Node parent, boolean complexProp) throws StorageException {
        this.checkLive();
        List<SimpleFragment> children = this.context.getChildren(parent.getId(), null, complexProp);
        return children.size() > 0;
    }

    @Override
    public List<Node> getChildren(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        List<SimpleFragment> fragments = this.context.getChildren(parent.getId(), name, complexProp);
        ArrayList<Node> nodes = new ArrayList<Node>(fragments.size());
        for (SimpleFragment fragment : fragments) {
            Node node = this.getNodeById(fragment.getId());
            if (node == null) {
                log.error((Object)("Child node cannot be created: " + fragment.getId()));
                continue;
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void orderBefore(Node parent, Node source, Node dest) throws StorageException {
        this.checkLive();
        this.context.orderBefore(parent.getId(), source.getId(), dest == null ? null : dest.getId());
    }

    @Override
    public Node move(Node source, Node parent, String name) throws StorageException {
        this.checkLive();
        if (!parent.getId().equals(source.getParentId())) {
            this.flush();
        }
        this.context.move(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return source;
    }

    @Override
    public Node copy(Node source, Node parent, String name) throws StorageException {
        this.checkLive();
        this.flush();
        Serializable id = this.context.copy(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return this.getNodeById(id);
    }

    @Override
    public void removeNode(Node node) throws StorageException {
        this.checkLive();
        boolean isVersion = Boolean.TRUE.equals(node.getSimpleProperty("ecm:isVersion").getValue());
        Serializable versionSeriesId = null;
        if (isVersion) {
            versionSeriesId = node.getSimpleProperty("ecm:versionableId").getValue();
        }
        this.context.removeNode(node.getHierFragment());
        if (isVersion) {
            this.context.recomputeVersionSeries(versionSeriesId);
        }
    }

    @Override
    public Node checkIn(Node node, String label, String checkinComment) throws StorageException {
        this.checkLive();
        this.flush();
        Serializable id = this.context.checkIn(node, label, checkinComment);
        this.requireReadAclsUpdate();
        this.flush();
        return this.getNodeById(id);
    }

    @Override
    public void checkOut(Node node) throws StorageException {
        this.checkLive();
        this.context.checkOut(node);
        this.requireReadAclsUpdate();
    }

    @Override
    public void restore(Node node, Node version) throws StorageException {
        this.checkLive();
        this.context.restoreVersion(node, version);
        this.requireReadAclsUpdate();
    }

    @Override
    public Node getVersionByLabel(Serializable versionSeriesId, String label) throws StorageException {
        this.checkLive();
        this.flush();
        Serializable id = this.mapper.getVersionIdByLabel(versionSeriesId, label);
        return id == null ? null : this.getNodeById(id);
    }

    @Override
    public Node getLastVersion(Serializable versionSeriesId) throws StorageException {
        this.checkLive();
        this.flush();
        Serializable id = this.mapper.getLastVersionId(versionSeriesId);
        return id == null ? null : this.getNodeById(id);
    }

    @Override
    public List<Node> getVersions(Serializable versionSeriesId) throws StorageException {
        this.checkLive();
        this.flush();
        List<Serializable> ids = this.context.getVersionIds(versionSeriesId);
        ArrayList<Node> nodes = new ArrayList<Node>(ids.size());
        for (Serializable id : ids) {
            nodes.add(this.getNodeById(id));
        }
        return nodes;
    }

    @Override
    public List<Node> getProxies(Node document, Node parent) throws StorageException {
        Object searchId;
        boolean byTarget;
        this.checkLive();
        this.flush();
        if (document.isVersion()) {
            byTarget = true;
            searchId = document.getId();
        } else {
            byTarget = false;
            searchId = document.isProxy() ? document.getSimpleProperty("ecm:proxyVersionableId").getString() : document.getId();
        }
        Serializable parentId = parent == null ? null : parent.getId();
        List<Serializable> ids = this.context.getProxyIds((Serializable)searchId, byTarget, parentId);
        ArrayList<Node> nodes = new ArrayList<Node>(ids.size());
        for (Serializable id : ids) {
            nodes.add(this.getNodeById(id));
        }
        return nodes;
    }

    @Override
    public PartialList<Serializable> query(String query, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        return this.mapper.query(query, "NXQL", queryFilter, countTotal);
    }

    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        return this.mapper.query(query, queryType, queryFilter, countTotal);
    }

    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) throws StorageException {
        return this.mapper.queryAndFetch(query, queryType, queryFilter, params);
    }

    @Override
    public Lock getLock(Serializable id) throws StorageException {
        return this.repository.getLockManager().getLock(id);
    }

    @Override
    public Lock setLock(Serializable id, Lock lock) throws StorageException {
        if (lock == null) {
            throw new NullPointerException("Attempt to use null lock on: " + id);
        }
        return this.repository.getLockManager().setLock(id, lock);
    }

    @Override
    public Lock removeLock(Serializable id, String owner, boolean force) throws StorageException {
        return this.repository.getLockManager().removeLock(id, owner);
    }

    @Override
    public void requireReadAclsUpdate() {
        this.readAclsChanged = true;
    }

    @Override
    public void updateReadAcls() throws StorageException {
        this.mapper.updateReadAcls();
        this.readAclsChanged = false;
    }

    @Override
    public void rebuildReadAcls() throws StorageException {
        this.mapper.rebuildReadAcls();
        this.readAclsChanged = false;
    }

    private void computeRootNode() throws StorageException {
        String repositoryId = "default";
        Serializable rootId = this.mapper.getRootId((Serializable)((Object)repositoryId));
        if (rootId == null) {
            log.debug((Object)"Creating root");
            this.rootNode = this.addRootNode();
            this.addRootACP();
            this.save();
            this.mapper.setRootId((Serializable)((Object)repositoryId), this.rootNode.getId());
        } else {
            this.rootNode = this.getNodeById(rootId, false);
        }
    }

    private Node addRootNode() throws StorageException {
        Serializable id = this.generateNewId(null);
        return this.addNode(id, null, "", null, "Root", false);
    }

    private void addRootACP() throws StorageException {
        Serializable[] aclrows = new ACLRow[]{new ACLRow(0, "local", true, "Everything", "administrators", null), new ACLRow(1, "local", true, "Everything", "Administrator", null), new ACLRow(2, "local", true, "Read", "members", null)};
        this.rootNode.setCollectionProperty("ecm:acl", aclrows);
        this.requireReadAclsUpdate();
    }

    public void checkPermission(String absPath, String actions) throws StorageException {
        this.checkLive();
        throw new RuntimeException("Not implemented");
    }

    public boolean hasPendingChanges() throws StorageException {
        this.checkLive();
        throw new RuntimeException("Not implemented");
    }

    public void markReferencedBinaries(BinaryGarbageCollector gc) {
        this.checkLive();
        try {
            this.mapper.markReferencedBinaries(gc);
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public boolean isSameRM(XAResource xaresource) {
        return xaresource == this;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0) {
            try {
                this.processReceivedInvalidations();
            }
            catch (Exception e) {
                log.error((Object)"Could not start transaction", (Throwable)e);
                throw (XAException)new XAException(-3).initCause(e);
            }
        }
        this.mapper.start(xid, flags);
        this.inTransaction = true;
        this.checkThreadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        boolean failed = true;
        try {
            if (flags != 0x20000000) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    String msg = "Could not end transaction";
                    if (e instanceof ConcurrentModificationException) {
                        log.debug((Object)msg, (Throwable)e);
                    } else {
                        log.error((Object)msg, (Throwable)e);
                    }
                    throw (XAException)new XAException(-3).initCause(e);
                }
            }
            failed = false;
            this.mapper.end(xid, flags);
        }
        finally {
            if (failed) {
                try {
                    this.mapper.end(xid, 0x20000000);
                }
                finally {
                    this.rollback(xid);
                }
            }
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int res = this.mapper.prepare(xid);
        if (res == 3) {
            this.commitDone();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.mapper.commit(xid, onePhase);
        }
        finally {
            this.commitDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitDone() throws XAException {
        this.inTransaction = false;
        try {
            try {
                this.sendInvalidationsToOthers();
            }
            finally {
                this.checkThreadEnd();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not send invalidations", (Throwable)e);
            throw (XAException)new XAException(-3).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            try {
                this.mapper.rollback(xid);
            }
            finally {
                this.rollback();
            }
        }
        finally {
            this.inTransaction = false;
            this.checkThreadEnd();
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.mapper.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.mapper.recover(flag);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.mapper.setTransactionTimeout(seconds);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.mapper.getTransactionTimeout();
    }
}

