/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.ListDiff;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBaseProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLComplexListProperty
extends SQLBaseProperty {
    protected final Node node;
    protected final String name;
    protected final SQLSession session;
    protected final ComplexType elementType;

    public SQLComplexListProperty(Node node, ListType type, String name, SQLSession session, boolean readonly) {
        super((Type)type, name, readonly);
        this.node = node;
        this.name = name;
        this.session = session;
        this.elementType = (ComplexType)type.getFieldType();
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getValue() throws DocumentException {
        List<Property> properties = this.session.makeProperties(this.node, this.name, this.type, null, this.readonly, -1);
        ArrayList<Object> list = new ArrayList<Object>(properties.size());
        for (Property property : properties) {
            list.add(property.getValue());
        }
        return list;
    }

    public void setValue(Object value) throws DocumentException {
        this.checkWritable();
        if (value instanceof ListDiff) {
            this.setList((ListDiff)value);
        } else if (value instanceof List) {
            this.setList((List)value);
        } else {
            throw new IllegalArgumentException("Unsupported value object for a complex list: " + value.getClass().getName());
        }
    }

    public void setList(List<?> list) throws DocumentException {
        if (this.getValue().equals(list)) {
            return;
        }
        List<Node> nodes = this.session.getComplexList(this.node, this.name);
        for (Node n : nodes) {
            this.session.remove(n);
        }
        List<Property> properties = this.session.makeProperties(this.node, this.name, this.type, null, this.readonly, list.size());
        int i = 0;
        for (Object value : list) {
            properties.get(i++).setValue(value);
        }
    }

    public void setList(ListDiff list) {
        if (!list.isDirty()) {
            return;
        }
        block7: for (ListDiff.Entry entry : list.diff()) {
            switch (entry.type) {
                case 1: {
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 2: {
                    continue block7;
                }
                case 5: {
                    continue block7;
                }
                case 4: {
                    continue block7;
                }
            }
        }
        throw new UnsupportedOperationException();
    }
}

