/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FullTextUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableAlias;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class NXQLQueryMaker
implements QueryMaker {
    private static final Log log = LogFactory.getLog(NXQLQueryMaker.class);
    public static final String TYPE_DOCUMENT = "Document";
    public static final String TYPE_RELATION = "Relation";
    protected static final String TABLE_HIER_ALIAS = "_H";
    protected static final String COL_ALIAS_PREFIX = "_C";
    protected static final String UNION_ALIAS = "_T";
    protected static final String WITH_ALIAS_PREFIX = "_W";
    protected static final String DATE_CAST = "DATE";
    protected static final Set<String> MIXINS_NOT_PER_INSTANCE = new HashSet<String>(Arrays.asList("Folderish", "HiddenInNavigation"));
    protected SQLInfo sqlInfo;
    protected Database database;
    protected Dialect dialect;
    protected Model model;
    public boolean onlyRelations;
    public boolean needsVersionsTable;
    protected Boolean proxyClause;
    protected List<Join> joins;
    protected List<String> whereClauses;
    protected List<Serializable> whereParams;

    @Override
    public String getName() {
        return "NXQL";
    }

    @Override
    public boolean accepts(String queryType) {
        return queryType.equals("NXQL");
    }

    @Override
    public QueryMaker.Query buildQuery(SQLInfo sqlInfo, Model model, Session.PathResolver pathResolver, String query, QueryFilter queryFilter, Object ... params) throws StorageException {
        this.sqlInfo = sqlInfo;
        this.database = sqlInfo.database;
        this.dialect = sqlInfo.dialect;
        this.model = model;
        SQLQuery sqlQuery = SQLQueryParser.parse((String)query);
        for (SQLQuery.Transformer transformer : queryFilter.getQueryTransformers()) {
            sqlQuery = transformer.transform(queryFilter.getPrincipal(), sqlQuery);
        }
        QueryAnalyzer info = this.newQueryAnalyzer(queryFilter.getFacetFilter());
        try {
            info.visitQuery(sqlQuery);
        }
        catch (QueryMaker.QueryCannotMatchException e) {
            return null;
        }
        catch (QueryMaker.QueryMakerException e) {
            throw new StorageException(e.getMessage(), e);
        }
        LinkedHashSet<String> fragmentNames = new LinkedHashSet<String>();
        for (String prop : info.props) {
            ModelProperty propertyInfo = model.getPropertyInfo(prop);
            if (propertyInfo == null) {
                throw new StorageException("Unknown field: " + prop);
            }
            fragmentNames.add(propertyInfo.fragmentName);
        }
        fragmentNames.remove("hierarchy");
        if (this.needsVersionsTable) {
            fragmentNames.add("versions");
        }
        if (this.onlyRelations) {
            if (this.proxyClause == Boolean.TRUE) {
                return null;
            }
            this.proxyClause = Boolean.FALSE;
        }
        DocKind[] docKinds = this.proxyClause == Boolean.TRUE ? new DocKind[]{DocKind.PROXY} : (this.proxyClause == Boolean.FALSE ? new DocKind[]{DocKind.DIRECT} : new DocKind[]{DocKind.DIRECT, DocKind.PROXY});
        Table hier = this.database.getTable("hierarchy");
        List<Column> whatColumns = null;
        List<String> whatKeys = null;
        boolean doUnion = docKinds.length > 1;
        Select select = null;
        String orderBy = null;
        ArrayList<String> statements = new ArrayList<String>(2);
        LinkedList<Serializable> selectParams = new LinkedList<Serializable>();
        LinkedList<String> withTables = new LinkedList<String>();
        LinkedList<Select> withSelects = new LinkedList<Select>();
        LinkedList<String> withSelectsStatements = new LinkedList<String>();
        LinkedList withParams = new LinkedList();
        boolean distinct = sqlQuery.select.isDistinct();
        for (DocKind docKind : docKinds) {
            WhereBuilder whereBuilder;
            String from;
            String dataHierId;
            Table dataHierTable;
            String hierId;
            Table hierTable;
            this.joins = new LinkedList<Join>();
            this.whereClauses = new LinkedList<String>();
            this.whereParams = new LinkedList<Serializable>();
            switch (docKind) {
                case DIRECT: {
                    hierTable = hier;
                    hierId = hierTable.getColumn("id").getFullQuotedName();
                    dataHierTable = hierTable;
                    dataHierId = hierId;
                    from = hierTable.getQuotedName();
                    break;
                }
                case PROXY: {
                    hierTable = new TableAlias(hier, TABLE_HIER_ALIAS);
                    from = hier.getQuotedName() + " " + hierTable.getQuotedName();
                    hierId = hierTable.getColumn("id").getFullQuotedName();
                    dataHierTable = hier;
                    dataHierId = hier.getColumn("id").getFullQuotedName();
                    Table proxies = this.database.getTable("proxies");
                    String proxiesid = proxies.getColumn("id").getFullQuotedName();
                    String proxiestargetid = proxies.getColumn("targetid").getFullQuotedName();
                    this.joins.add(new Join(1, proxies.getQuotedName(), null, null, hierId, proxiesid));
                    this.joins.add(new Join(1, dataHierTable.getQuotedName(), null, null, dataHierId, proxiestargetid));
                    break;
                }
                default: {
                    throw new AssertionError((Object)docKind);
                }
            }
            for (String fragmentName : fragmentNames) {
                Table table = this.database.getTable(fragmentName);
                String joinId = "versions".equals(fragmentName) ? hierId : dataHierId;
                this.addDataJoin(table, joinId);
            }
            this.fixJoins();
            try {
                whereBuilder = this.newWhereBuilder(this.database, model, pathResolver, this.dialect, hierTable, hierId, dataHierTable, dataHierId, docKind == DocKind.PROXY);
            }
            catch (QueryMaker.QueryMakerException e) {
                throw new StorageException(e.getMessage(), e);
            }
            sqlQuery.select.accept((IVisitor)whereBuilder);
            if (whereBuilder.whatColumns.isEmpty()) {
                whatColumns = Collections.singletonList(hierTable.getColumn("id"));
                whatKeys = Collections.singletonList("id");
            } else {
                whatColumns = whereBuilder.whatColumns;
                whatKeys = whereBuilder.whatKeys;
            }
            if (info.wherePredicate != null) {
                info.wherePredicate.accept((IVisitor)whereBuilder);
                this.joins.addAll(whereBuilder.joins);
                String where = whereBuilder.buf.toString();
                if (where.length() != 0) {
                    this.whereClauses.add(where);
                    this.whereParams.addAll(whereBuilder.whereParams);
                }
            }
            Dialect.FulltextMatchInfo ftMatchInfo = whereBuilder.ftMatchInfo;
            boolean orderByScoreDesc = sqlQuery.orderBy == null && whereBuilder.ftJoinNumber == 1 && !distinct;
            int nalias = 0;
            ArrayList<String> whatNames = new ArrayList<String>(1);
            ArrayList<String> whatNamesParams = new ArrayList<String>(1);
            String mainAlias = hierId;
            for (Column col : whatColumns) {
                String name = this.getSelectColName(col);
                String alias = this.dialect.openQuote() + COL_ALIAS_PREFIX + ++nalias + this.dialect.closeQuote();
                name = name + " AS " + alias;
                if (col.getTable().getRealTable() == hier) {
                    if (col.getKey().equals("id")) {
                        mainAlias = alias;
                    }
                }
                whatNames.add(name);
            }
            this.fixWhatColumns(whatColumns);
            if (doUnion) {
                whereBuilder.nalias = nalias;
                for (String key : info.orderKeys) {
                    Column column = whereBuilder.findColumn(key, false, true);
                    String name = column.getFullQuotedName();
                    String alias = this.dialect.openQuote() + COL_ALIAS_PREFIX + ++nalias + this.dialect.closeQuote();
                    name = name + " AS " + alias;
                    whatNames.add(name);
                }
            }
            if (orderByScoreDesc) {
                String scoreExprSql = ftMatchInfo.scoreExpr + " AS " + ftMatchInfo.scoreAlias;
                whatNames.add(scoreExprSql);
                if (ftMatchInfo.scoreExprParam != null) {
                    whatNamesParams.add(ftMatchInfo.scoreExprParam);
                }
            }
            String selectWhat = StringUtils.join(whatNames, (String)", ");
            if (!doUnion && distinct) {
                selectWhat = "DISTINCT " + selectWhat;
            }
            String securityClause = null;
            LinkedList<Object[]> securityParams = new LinkedList<Object[]>();
            Join securityJoin = null;
            if (queryFilter.getPrincipals() != null) {
                String id;
                Object principals = queryFilter.getPrincipals();
                Object permissions = queryFilter.getPermissions();
                if (!this.dialect.supportsArrays()) {
                    principals = StringUtils.join((Object[])principals, (char)'|');
                    permissions = StringUtils.join((Object[])permissions, (char)'|');
                }
                String string = id = this.dialect.supportsWith() ? mainAlias : hierId;
                if (this.dialect.supportsReadAcl()) {
                    securityClause = this.dialect.getReadAclsCheckSql("r.acl_id");
                    securityParams.add((Object[])principals);
                    securityJoin = new Join(1, "hierarchy_read_acl", "r", null, id, "r.id");
                } else {
                    securityClause = this.dialect.getSecurityCheckSql(id);
                    securityParams.add((Object[])principals);
                    securityParams.add((Object[])permissions);
                }
            }
            if (orderBy == null) {
                if (sqlQuery.orderBy != null) {
                    whereBuilder.aliasColumns = doUnion;
                    whereBuilder.buf.setLength(0);
                    sqlQuery.orderBy.accept((IVisitor)whereBuilder);
                    orderBy = whereBuilder.buf.toString();
                } else if (orderByScoreDesc) {
                    orderBy = ftMatchInfo.scoreAlias + " DESC";
                }
            }
            if (securityClause != null) {
                if (this.dialect.supportsWith()) {
                    String withTable = this.dialect.openQuote() + WITH_ALIAS_PREFIX + (statements.size() + 1) + this.dialect.closeQuote();
                    withTables.add(withTable);
                    Select withSelect = new Select(null);
                    withSelect.setWhat("*");
                    withSelect.setFrom(withTable + (securityJoin == null ? "" : " " + securityJoin.toString()));
                    withSelect.setWhere(securityClause);
                    withSelects.add(withSelect);
                    withSelectsStatements.add(withSelect.getStatement());
                    withParams.addAll(securityParams);
                } else {
                    if (securityJoin != null) {
                        this.joins.add(securityJoin);
                    }
                    this.whereClauses.add(securityClause);
                    this.whereParams.addAll(securityParams);
                }
            }
            select = new Select(null);
            select.setWhat(selectWhat);
            selectParams.addAll(whatNamesParams);
            StringBuilder fromb = new StringBuilder(from);
            if (this.dialect.needsOracleJoins()) {
                LinkedList<String> joinClauses = new LinkedList<String>();
                for (Join join : this.joins) {
                    fromb.append(", ");
                    fromb.append(join.getTable());
                    if (join.tableParam != null) {
                        selectParams.add((Serializable)((Object)join.tableParam));
                    }
                    String joinClause = join.getClause();
                    if (join.kind == 2) {
                        joinClause = joinClause + "(+)";
                    }
                    joinClauses.add(joinClause);
                }
                this.whereClauses.addAll(0, joinClauses);
            } else {
                Collections.sort(this.joins);
                for (Join join : this.joins) {
                    fromb.append(join.toString());
                    if (join.tableParam == null) continue;
                    selectParams.add((Serializable)((Object)join.tableParam));
                }
            }
            select.setFrom(fromb.toString());
            select.setWhere(StringUtils.join(this.whereClauses, (String)" AND "));
            selectParams.addAll(this.whereParams);
            statements.add(select.getStatement());
        }
        if (doUnion) {
            String subselect;
            select = new Select(null);
            ArrayList<String> whatNames = new ArrayList<String>(whatColumns.size());
            for (int nalias = 1; nalias <= whatColumns.size(); ++nalias) {
                String name = this.dialect.openQuote() + COL_ALIAS_PREFIX + nalias + this.dialect.closeQuote();
                whatNames.add(name);
            }
            String selectWhat = StringUtils.join(whatNames, (String)", ");
            if (distinct) {
                selectWhat = "DISTINCT " + selectWhat;
            }
            select.setWhat(selectWhat);
            if (withSelects.isEmpty()) {
                subselect = StringUtils.join(statements, (String)" UNION ALL ");
            } else {
                StringBuilder with = new StringBuilder("WITH ");
                for (int i = 0; i < statements.size(); ++i) {
                    if (i > 0) {
                        with.append(", ");
                    }
                    with.append((String)withTables.get(i));
                    with.append(" AS (");
                    with.append((String)statements.get(i));
                    with.append(')');
                }
                with.append(' ');
                subselect = with.toString() + StringUtils.join(withSelectsStatements, (String)" UNION ALL ");
                selectParams.addAll(withParams);
            }
            String selectFrom = '(' + subselect + ')';
            if (this.dialect.needsAliasForDerivedTable()) {
                selectFrom = selectFrom + " AS " + this.dialect.openQuote() + UNION_ALIAS + this.dialect.closeQuote();
            }
            select.setFrom(selectFrom);
        } else if (!withSelects.isEmpty()) {
            select = new Select(null);
            String with = (String)withTables.get(0) + " AS (" + (String)statements.get(0) + ')';
            select.setWith(with);
            Select withSelect = (Select)withSelects.get(0);
            select.setWhat(withSelect.getWhat());
            select.setFrom(withSelect.getFrom());
            select.setWhere(withSelect.getWhere());
            selectParams.addAll(withParams);
        }
        select.setOrderBy(orderBy);
        this.fixSelect(select);
        QueryMaker.Query q = new QueryMaker.Query();
        SQLInfo.ColumnMapMaker mapMaker = new SQLInfo.ColumnMapMaker(whatColumns, whatKeys);
        q.selectInfo = new SQLInfo.SQLInfoSelect(select.getStatement(), whatColumns, mapMaker, null, null);
        q.selectParams = selectParams;
        return q;
    }

    protected void addDataJoin(Table table, String joinId) {
        this.joins.add(this.formatJoin(table, joinId));
    }

    protected Join formatJoin(Table table, String joinId) {
        return new Join(2, table.getQuotedName(), null, null, joinId, table.getColumn("id").getFullQuotedName());
    }

    protected void fixJoins() {
    }

    protected String getSelectColName(Column col) {
        return col.getFullQuotedName();
    }

    protected void fixWhatColumns(List<Column> whatColumns) {
    }

    protected void fixSelect(Select select) {
    }

    protected static boolean findFulltextIndexOrField(Model model, String[] nameref) {
        boolean useIndex;
        String name = nameref[0];
        if (name.equals("ecm:fulltext")) {
            name = "default";
            useIndex = true;
        } else {
            char sep = name.charAt("ecm:fulltext".length());
            if (sep != '.' && sep != '_') {
                throw new QueryMaker.QueryMakerException("Unknown field: " + name);
            }
            useIndex = sep == '_';
            name = name.substring("ecm:fulltext".length() + 1);
            if (useIndex) {
                if (!model.fulltextInfo.indexNames.contains(name)) {
                    throw new QueryMaker.QueryMakerException("No such fulltext index: " + name);
                }
            } else {
                String index = model.fulltextInfo.fieldToIndexName.get(name);
                if (index != null) {
                    name = index;
                    useIndex = true;
                }
            }
        }
        nameref[0] = name;
        return useIndex;
    }

    protected QueryAnalyzer newQueryAnalyzer(FacetFilter facetFilter) {
        return new QueryAnalyzer(facetFilter);
    }

    protected WhereBuilder newWhereBuilder(Database database, Model model, Session.PathResolver pathResolver, Dialect dialect, Table hierTable, String hierId, Table dataHierTable, String dataHierId, boolean isProxies) {
        return new WhereBuilder(database, model, pathResolver, dialect, hierTable, hierId, dataHierTable, dataHierId, isProxies);
    }

    public static class WhereBuilder
    extends DefaultQueryVisitor {
        private static final long serialVersionUID = 1L;
        public static final String PATH_SEP = "/";
        public final List<Column> whatColumns = new LinkedList<Column>();
        public final List<String> whatKeys = new LinkedList<String>();
        public final StringBuilder buf = new StringBuilder();
        public final List<Join> joins = new LinkedList<Join>();
        public final List<Serializable> whereParams = new LinkedList<Serializable>();
        private final Session.PathResolver pathResolver;
        private final Model model;
        private final Dialect dialect;
        private final Database database;
        private final Table hierTable;
        private final String hierId;
        private final Table dataHierTable;
        private final String dataHierId;
        private final boolean isProxies;
        private boolean aliasColumns;
        protected boolean allowArray;
        protected boolean inSelect;
        protected boolean inOrderBy;
        private int nalias = 0;
        protected int ftJoinNumber;
        protected Dialect.FulltextMatchInfo ftMatchInfo;

        public WhereBuilder(Database database, Model model, Session.PathResolver pathResolver, Dialect dialect, Table hierTable, String hierId, Table dataHierTable, String dataHierId, boolean isProxies) {
            this.pathResolver = pathResolver;
            this.model = model;
            this.dialect = dialect;
            this.database = database;
            this.hierTable = hierTable;
            this.hierId = hierId;
            this.dataHierTable = dataHierTable;
            this.dataHierId = dataHierId;
            this.isProxies = isProxies;
        }

        public Column findColumn(String name, boolean allowArray, boolean inOrderBy) {
            Column column;
            if (name.startsWith("ecm:")) {
                column = this.getSpecialColumn(name);
            } else {
                ModelProperty propertyInfo = this.model.getPropertyInfo(name);
                if (propertyInfo == null) {
                    throw new QueryMaker.QueryMakerException("Unknown field: " + name);
                }
                Table table = this.database.getTable(propertyInfo.fragmentName);
                if (propertyInfo.propertyType.isArray()) {
                    if (!allowArray) {
                        String msg = inOrderBy ? "Cannot use collection %s in ORDER BY clause" : "Can only use collection %s with =, <>, IN or NOT IN clause";
                        throw new QueryMaker.QueryMakerException(String.format(msg, name));
                    }
                    column = table.getColumn("item");
                } else {
                    column = table.getColumn(propertyInfo.fragmentKey);
                }
            }
            return column;
        }

        protected Column getSpecialColumn(String name) {
            if ("ecm:primaryType".equals(name)) {
                return this.dataHierTable.getColumn("primarytype");
            }
            if ("ecm:mixinType".equals(name)) {
                throw new QueryMaker.QueryMakerException("Cannot use non-toplevel " + name + " in query");
            }
            if ("ecm:uuid".equals(name)) {
                return this.hierTable.getColumn("id");
            }
            if ("ecm:name".equals(name)) {
                return this.hierTable.getColumn("name");
            }
            if ("ecm:pos".equals(name)) {
                return this.hierTable.getColumn("pos");
            }
            if ("ecm:parentId".equals(name)) {
                return this.hierTable.getColumn("parentid");
            }
            if ("ecm:currentLifeCycleState".equals(name)) {
                return this.database.getTable("misc").getColumn("lifecyclestate");
            }
            if ("ecm:fulltextJobId".equals(name)) {
                return this.database.getTable("fulltext").getColumn("jobid");
            }
            if (name.startsWith("ecm:fulltext")) {
                throw new QueryMaker.QueryMakerException("ecm:fulltext must be used as left-hand operand");
            }
            if ("ecm:versionLabel".equals(name)) {
                return this.database.getTable("versions").getColumn("label");
            }
            if ("ecm:lock".equals(name) || "ecm:lockOwner".equals(name)) {
                return this.database.getTable("locks").getColumn("owner");
            }
            if ("ecm:lockCreated".equals(name)) {
                return this.database.getTable("locks").getColumn("created");
            }
            throw new QueryMaker.QueryMakerException("Unknown field: " + name);
        }

        protected static Set<String> getStringLiterals(LiteralList list) throws QueryMaker.QueryMakerException {
            HashSet<String> set = new HashSet<String>();
            for (Literal literal : list) {
                if (!(literal instanceof StringLiteral)) {
                    throw new QueryMaker.QueryMakerException("requires string literals");
                }
                set.add(((StringLiteral)literal).value);
            }
            return set;
        }

        public void visitQuery(SQLQuery node) {
            super.visitQuery(node);
        }

        public void visitSelectClause(SelectClause node) {
            this.inSelect = true;
            super.visitSelectClause(node);
            this.inSelect = false;
        }

        public void visitMultiExpression(MultiExpression node) {
            this.buf.append('(');
            Iterator it = node.values.iterator();
            while (it.hasNext()) {
                ((Operand)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                node.operator.accept((IVisitor)this);
            }
            this.buf.append(')');
        }

        public void visitExpression(Expression node) {
            Operator op;
            this.buf.append('(');
            Reference ref = node.lvalue instanceof Reference ? (Reference)node.lvalue : null;
            String name = ref != null ? ref.name : null;
            String cast = ref != null ? ref.cast : null;
            Operand rvalue = node.rvalue;
            if (NXQLQueryMaker.DATE_CAST.equals(cast)) {
                this.checkDateLiteralForCast(rvalue, node);
            }
            if ((op = node.operator) == Operator.STARTSWITH) {
                this.visitExpressionStartsWith(node, name);
            } else if ("ecm:path".equals(name)) {
                this.visitExpressionEcmPath(node);
            } else if ("ecm:isProxy".equals(name)) {
                this.visitExpressionIsProxy(node);
            } else if ("ecm:isCheckedInVersion".equals(name)) {
                this.visitExpressionIsVersion(node);
            } else if ("ecm:mixinType".equals(name)) {
                this.visitExpressionMixinType(node);
            } else if (name != null && name.startsWith("ecm:fulltext") && !"ecm:fulltextJobId".equals(name)) {
                this.visitExpressionFulltext(node, name);
            } else if (!(op != Operator.EQ && op != Operator.NOTEQ && op != Operator.IN && op != Operator.NOTIN && op != Operator.LIKE && op != Operator.NOTLIKE && op != Operator.ILIKE && op != Operator.NOTILIKE || name == null || name.startsWith("ecm:"))) {
                ModelProperty propertyInfo = this.model.getPropertyInfo(name);
                if (propertyInfo == null) {
                    throw new QueryMaker.QueryMakerException("Unknown field: " + name);
                }
                if (propertyInfo.propertyType.isArray()) {
                    boolean direct;
                    boolean bl = direct = op == Operator.EQ || op == Operator.IN || op == Operator.LIKE || op == Operator.ILIKE;
                    Operator directOp = direct ? op : (op == Operator.NOTEQ ? Operator.EQ : (op == Operator.NOTIN ? Operator.IN : (op == Operator.NOTLIKE ? Operator.LIKE : Operator.ILIKE)));
                    Table table = this.database.getTable(propertyInfo.fragmentName);
                    if (!direct) {
                        this.buf.append("NOT ");
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[0] = table.getQuotedName();
                    objectArray[1] = this.dataHierId;
                    objectArray[2] = table.getColumn("id").getFullQuotedName();
                    this.buf.append(String.format("EXISTS (SELECT 1 FROM %s WHERE %s = %s AND (", objectArray));
                    this.allowArray = true;
                    if (directOp == Operator.ILIKE) {
                        this.visitExpressionIlike(node, directOp);
                    } else {
                        node.lvalue.accept((IVisitor)this);
                        directOp.accept((IVisitor)this);
                        rvalue.accept((IVisitor)this);
                    }
                    this.allowArray = false;
                    this.buf.append("))");
                } else {
                    if (propertyInfo.propertyType == PropertyType.BOOLEAN) {
                        if (!(rvalue instanceof IntegerLiteral)) {
                            throw new QueryMaker.QueryMakerException("Boolean expressions require literal 0 or 1 as right argument");
                        }
                        long v = ((IntegerLiteral)rvalue).value;
                        if (v != 0L && v != 1L) {
                            throw new QueryMaker.QueryMakerException("Boolean expressions require literal 0 or 1 as right argument");
                        }
                        node = new Predicate(node.lvalue, node.operator, (Operand)new BooleanLiteral(v == 1L));
                    }
                    if (op == Operator.ILIKE || op == Operator.NOTILIKE) {
                        this.visitExpressionIlike(node, node.operator);
                    } else {
                        super.visitExpression(node);
                    }
                }
            } else if (node.operator == Operator.BETWEEN || node.operator == Operator.NOTBETWEEN) {
                LiteralList l = (LiteralList)rvalue;
                if (NXQLQueryMaker.DATE_CAST.equals(cast)) {
                    this.checkDateLiteralForCast((Operand)l.get(0), node);
                    this.checkDateLiteralForCast((Operand)l.get(1), node);
                }
                node.lvalue.accept((IVisitor)this);
                this.buf.append(' ');
                node.operator.accept((IVisitor)this);
                this.buf.append(' ');
                ((Literal)l.get(0)).accept((IVisitor)this);
                this.buf.append(" AND ");
                ((Literal)l.get(1)).accept((IVisitor)this);
            } else {
                super.visitExpression(node);
            }
            this.buf.append(')');
        }

        protected void checkDateLiteralForCast(Operand value, Expression node) {
            if (value instanceof DateLiteral && !((DateLiteral)value).onlyDate) {
                throw new QueryMaker.QueryMakerException("DATE() cast must be used with DATE literal, not TIMESTAMP: " + node);
            }
        }

        protected void visitExpressionStartsWith(Expression node, String name) {
            if (name == null) {
                throw new QueryMaker.QueryMakerException("Illegal left argument for " + Operator.STARTSWITH + ": " + node.lvalue);
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMaker.QueryMakerException(Operator.STARTSWITH + " requires literal path as right argument");
            }
            String path = ((StringLiteral)node.rvalue).value;
            if (path.length() > 1 && path.endsWith(PATH_SEP)) {
                path = path.substring(0, path.length() - PATH_SEP.length());
            }
            if ("ecm:path".equals(name)) {
                this.visitExpressionStartsWithPath(node, path);
            } else {
                this.visitExpressionStartsWithNonPath(node, name, path);
            }
        }

        protected void visitExpressionStartsWithPath(Expression node, String path) {
            Serializable id;
            try {
                id = this.pathResolver.getIdForPath(path);
            }
            catch (StorageException e) {
                throw new QueryMaker.QueryMakerException((Throwable)((Object)e));
            }
            if (id == null) {
                this.buf.append("0=1");
            } else {
                this.buf.append(this.dialect.getInTreeSql(this.hierId));
                this.whereParams.add(id);
            }
        }

        protected void visitExpressionStartsWithNonPath(Expression node, String name, String path) {
            ModelProperty propertyInfo = this.model.getPropertyInfo(name);
            if (propertyInfo == null) {
                throw new QueryMaker.QueryMakerException("Unknown field: " + name);
            }
            boolean isArray = propertyInfo.propertyType.isArray();
            if (isArray) {
                Table table = this.database.getTable(propertyInfo.fragmentName);
                Object[] objectArray = new Object[3];
                objectArray[0] = table.getQuotedName();
                objectArray[1] = this.dataHierId;
                objectArray[2] = table.getColumn("id").getFullQuotedName();
                this.buf.append(String.format("EXISTS (SELECT 1 FROM %s WHERE %s = %s AND ", objectArray));
            }
            this.buf.append('(');
            this.allowArray = true;
            node.lvalue.accept((IVisitor)this);
            this.buf.append(" = ");
            node.rvalue.accept((IVisitor)this);
            this.buf.append(" OR ");
            node.lvalue.accept((IVisitor)this);
            this.buf.append(" LIKE ");
            new StringLiteral(path + PATH_SEP + '%').accept((IVisitor)this);
            this.allowArray = false;
            this.buf.append(')');
            if (isArray) {
                this.buf.append(')');
            }
        }

        protected void visitExpressionEcmPath(Expression node) {
            Serializable id;
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMaker.QueryMakerException("ecm:path requires = or <> operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:path requires literal path as right argument");
            }
            String path = ((StringLiteral)node.rvalue).value;
            if (path.length() > 1 && path.endsWith(PATH_SEP)) {
                path = path.substring(0, path.length() - PATH_SEP.length());
            }
            try {
                id = this.pathResolver.getIdForPath(path);
            }
            catch (StorageException e) {
                throw new QueryMaker.QueryMakerException((Throwable)((Object)e));
            }
            if (id == null) {
                this.buf.append("0=1");
            } else {
                this.buf.append(this.hierTable.getColumn("id").getFullQuotedName());
                this.visitOperator(node.operator);
                this.buf.append('?');
                this.whereParams.add(id);
            }
        }

        protected void visitExpressionIsProxy(Expression node) {
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires = or <> operator");
            }
            if (!(node.rvalue instanceof IntegerLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)node.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            boolean bool = node.operator == Operator.EQ ^ v == 0L;
            this.buf.append(this.isProxies == bool ? "1=1" : "0=1");
        }

        protected void visitExpressionIsVersion(Expression node) {
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMaker.QueryMakerException("ecm:isCheckedInVersion requires = or <> operator");
            }
            if (!(node.rvalue instanceof IntegerLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:isCheckedInVersion requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)node.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryMaker.QueryMakerException("ecm:isCheckedInVersion requires literal 0 or 1 as right argument");
            }
            boolean bool = node.operator == Operator.EQ ^ v == 0L;
            this.buf.append(this.database.getTable("versions").getColumn("id").getFullQuotedName());
            this.buf.append(bool ? " IS NOT NULL" : " IS NULL");
        }

        protected void visitExpressionMixinType(Expression node) {
            HashSet<Object> types;
            Set<String> mixins;
            boolean include;
            Expression expr = node;
            Operator op = expr.operator;
            if (op == Operator.EQ || op == Operator.NOTEQ) {
                boolean bl = include = op == Operator.EQ;
                if (!(expr.rvalue instanceof StringLiteral)) {
                    throw new QueryMaker.QueryMakerException("ecm:mixinType = requires literal string as right argument");
                }
                String value = ((StringLiteral)expr.rvalue).value;
                mixins = Collections.singleton(value);
            } else if (op == Operator.IN || op == Operator.NOTIN) {
                boolean bl = include = op == Operator.IN;
                if (!(expr.rvalue instanceof LiteralList)) {
                    throw new QueryMaker.QueryMakerException("ecm:mixinType = requires string list as right argument");
                }
                mixins = WhereBuilder.getStringLiterals((LiteralList)expr.rvalue);
            } else {
                throw new QueryMaker.QueryMakerException("ecm:mixinType unknown operator: " + op);
            }
            if (include) {
                types = new HashSet();
                for (String mixin : mixins) {
                    types.addAll(this.model.getMixinDocumentTypes(mixin));
                }
            } else {
                types = new HashSet<String>(this.model.getDocumentTypes());
                for (String mixin : mixins) {
                    types.removeAll(this.model.getMixinDocumentTypes(mixin));
                }
            }
            HashSet<String> instanceMixins = new HashSet<String>();
            for (String mixin : mixins) {
                if (MIXINS_NOT_PER_INSTANCE.contains(mixin)) continue;
                instanceMixins.add(mixin);
            }
            if (!types.isEmpty()) {
                Column col = this.dataHierTable.getColumn("primarytype");
                this.buf.append(col.getFullQuotedName());
                this.buf.append(" IN ");
                this.buf.append('(');
                Iterator it = types.iterator();
                while (it.hasNext()) {
                    this.visitStringLiteral((String)it.next());
                    if (!it.hasNext()) continue;
                    this.buf.append(", ");
                }
                this.buf.append(')');
                if (!instanceMixins.isEmpty()) {
                    this.buf.append(include ? " OR " : " AND ");
                }
            }
            if (!instanceMixins.isEmpty()) {
                this.buf.append('(');
                Column mixinsColumn = this.dataHierTable.getColumn("mixintypes");
                String[] returnParam = new String[1];
                Iterator it = instanceMixins.iterator();
                while (it.hasNext()) {
                    String mixin = (String)it.next();
                    String sql = this.dialect.getMatchMixinType(mixinsColumn, mixin, include, returnParam);
                    this.buf.append(sql);
                    if (returnParam[0] != null) {
                        this.whereParams.add((Serializable)((Object)returnParam[0]));
                    }
                    if (!it.hasNext()) continue;
                    this.buf.append(include ? " OR " : " AND ");
                }
                if (!include) {
                    this.buf.append(" OR ");
                    this.buf.append(mixinsColumn.getFullQuotedName());
                    this.buf.append(" IS NULL");
                }
                this.buf.append(')');
            }
            if (types.isEmpty() && instanceMixins.isEmpty()) {
                this.buf.append(include ? "0=1" : "0=0");
            }
        }

        protected void visitExpressionFulltext(Expression node, String name) {
            String[] nameref = new String[]{name};
            boolean useIndex = NXQLQueryMaker.findFulltextIndexOrField(this.model, nameref);
            name = nameref[0];
            if (node.operator != Operator.EQ && node.operator != Operator.LIKE) {
                throw new QueryMaker.QueryMakerException("ecm:fulltext requires = or LIKE operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:fulltext requires literal string as right argument");
            }
            if (useIndex) {
                Dialect.FulltextMatchInfo info;
                String fulltextQuery = ((StringLiteral)node.rvalue).value;
                fulltextQuery = this.dialect.getDialectFulltextQuery(fulltextQuery);
                ++this.ftJoinNumber;
                Column mainColumn = this.dataHierTable.getColumn("id");
                this.ftMatchInfo = info = this.dialect.getFulltextScoredMatchInfo(fulltextQuery, name, this.ftJoinNumber, mainColumn, this.model, this.database);
                if (info.joins != null) {
                    this.joins.addAll(info.joins);
                }
                this.buf.append(info.whereExpr);
                if (info.whereExprParam != null) {
                    this.whereParams.add((Serializable)((Object)info.whereExprParam));
                }
            } else {
                log.warn((Object)("No fulltext index configured for field " + name + ", falling back on LIKE query"));
                String value = ((StringLiteral)node.rvalue).value;
                Set words = FullTextUtils.parseFullText((String)value, (boolean)false);
                value = words.isEmpty() ? "DONTMATCHANYTHINGFOREMPTYQUERY" : "%" + StringUtils.join(new ArrayList(words), (String)"%") + "%";
                Reference ref = new Reference(name);
                if (this.dialect.supportsIlike()) {
                    this.visitReference(ref);
                    this.buf.append(" ILIKE ");
                    this.visitStringLiteral(value);
                } else {
                    this.buf.append("LOWER(");
                    this.visitReference(ref);
                    this.buf.append(") LIKE ");
                    this.visitStringLiteral(value);
                }
            }
        }

        protected void visitExpressionIlike(Expression node, Operator op) {
            if (this.dialect.supportsIlike()) {
                node.lvalue.accept((IVisitor)this);
                op.accept((IVisitor)this);
                node.rvalue.accept((IVisitor)this);
            } else {
                this.buf.append("LOWER(");
                node.lvalue.accept((IVisitor)this);
                this.buf.append(") ");
                if (op == Operator.NOTILIKE) {
                    this.buf.append("NOT ");
                }
                this.buf.append("LIKE");
                this.buf.append(" LOWER(");
                node.rvalue.accept((IVisitor)this);
                this.buf.append(")");
            }
        }

        public void visitOperator(Operator node) {
            if (node != Operator.NOT) {
                this.buf.append(' ');
            }
            this.buf.append(node.toString());
            this.buf.append(' ');
        }

        public void visitReference(Reference node) {
            String name = node.name;
            Column column = this.findColumn(name, this.allowArray, this.inOrderBy);
            if (this.inSelect) {
                this.whatColumns.add(column);
                this.whatKeys.add(name);
            } else {
                this.visitReference(column, node.cast);
            }
        }

        protected void visitReference(Column column) {
            this.visitReference(column, null);
        }

        protected void visitReference(Column column, String cast) {
            String colFmt;
            if (NXQLQueryMaker.DATE_CAST.equals(cast) && column.getType() != ColumnType.TIMESTAMP) {
                throw new QueryMaker.QueryMakerException("Cannot cast to " + cast + ": " + column);
            }
            String qname = column.getFullQuotedName();
            if (column.getJdbcType() == 2005 && (colFmt = this.dialect.getClobCast(this.inOrderBy)) != null) {
                qname = String.format(colFmt, qname, 255);
            }
            if (cast != null) {
                String fmt = this.dialect.getDateCast();
                this.buf.append(String.format(fmt, qname));
            } else {
                this.buf.append(qname);
            }
        }

        public void visitLiteralList(LiteralList node) {
            this.buf.append('(');
            Iterator it = node.iterator();
            while (it.hasNext()) {
                ((Literal)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                this.buf.append(", ");
            }
            this.buf.append(')');
        }

        public void visitDateLiteral(DateLiteral node) {
            this.buf.append('?');
            if (node.onlyDate) {
                this.whereParams.add(node.toSqlDate());
            } else {
                this.whereParams.add(node.toCalendar());
            }
        }

        public void visitStringLiteral(StringLiteral node) {
            this.visitStringLiteral(node.value);
        }

        public void visitStringLiteral(String string) {
            this.buf.append('?');
            this.whereParams.add((Serializable)((Object)string));
        }

        public void visitDoubleLiteral(DoubleLiteral node) {
            this.buf.append('?');
            this.whereParams.add(Double.valueOf(node.value));
        }

        public void visitIntegerLiteral(IntegerLiteral node) {
            this.buf.append('?');
            this.whereParams.add(Long.valueOf(node.value));
        }

        public void visitBooleanLiteral(BooleanLiteral node) {
            this.buf.append('?');
            this.whereParams.add(Boolean.valueOf(node.value));
        }

        public void visitOrderByList(OrderByList node) {
            this.inOrderBy = true;
            Iterator it = node.iterator();
            while (it.hasNext()) {
                ((OrderByExpr)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                this.buf.append(", ");
            }
            this.inOrderBy = false;
        }

        public void visitOrderByExpr(OrderByExpr node) {
            if (this.aliasColumns) {
                this.buf.append(this.dialect.openQuote());
                this.buf.append(NXQLQueryMaker.COL_ALIAS_PREFIX);
                this.buf.append(++this.nalias);
                this.buf.append(this.dialect.closeQuote());
            } else {
                node.reference.accept((IVisitor)this);
            }
            if (node.isDescending) {
                this.buf.append(" DESC");
            }
        }
    }

    protected static class BooleanLiteral
    extends Literal {
        private static final long serialVersionUID = 1L;
        public final boolean value;

        public BooleanLiteral(boolean value) {
            this.value = value;
        }

        public void accept(IVisitor visitor) {
            ((WhereBuilder)visitor).visitBooleanLiteral(this);
        }

        public String asString() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BooleanLiteral) {
                return this.value == ((BooleanLiteral)((Object)obj)).value;
            }
            return false;
        }

        public int hashCode() {
            return Boolean.valueOf(this.value).hashCode();
        }
    }

    public class QueryAnalyzer
    extends DefaultQueryVisitor {
        private static final long serialVersionUID = 1L;
        public final Set<String> props = new LinkedHashSet<String>();
        public final List<String> orderKeys = new LinkedList<String>();
        protected boolean inSelect;
        protected boolean inOrderBy;
        protected final List<Operand> toplevelOperands = new LinkedList<Operand>();
        protected MultiExpression wherePredicate;

        public QueryAnalyzer(FacetFilter facetFilter) {
            if (facetFilter != null) {
                this.addFacetFilterClauses(facetFilter);
            }
        }

        public void addFacetFilterClauses(FacetFilter facetFilter) {
            Expression expr;
            for (String mixin : facetFilter.required) {
                expr = new Expression((Operand)new Reference("ecm:mixinType"), Operator.EQ, (Operand)new StringLiteral(mixin));
                this.toplevelOperands.add((Operand)expr);
            }
            if (!facetFilter.excluded.isEmpty()) {
                LiteralList list = new LiteralList();
                for (String mixin : facetFilter.excluded) {
                    list.add((Object)new StringLiteral(mixin));
                }
                expr = new Expression((Operand)new Reference("ecm:mixinType"), Operator.NOTIN, (Operand)list);
                this.toplevelOperands.add((Operand)expr);
            }
        }

        public void visitQuery(SQLQuery node) {
            this.visitSelectClause(node.select);
            this.visitFromClause(node.from);
            this.visitWhereClause(node.where);
            if (node.orderBy != null) {
                this.visitOrderByClause(node.orderBy);
            }
        }

        public void visitSelectClause(SelectClause node) {
            this.inSelect = true;
            super.visitSelectClause(node);
            this.inSelect = false;
        }

        public void visitFromClause(FromClause node) {
            NXQLQueryMaker.this.onlyRelations = true;
            HashSet<String> fromTypes = new HashSet<String>();
            FromList elements = node.elements;
            for (int i = 0; i < elements.size(); ++i) {
                Set<String> subTypes;
                String typeName = (String)elements.get(i);
                if (NXQLQueryMaker.TYPE_DOCUMENT.equalsIgnoreCase(typeName)) {
                    typeName = NXQLQueryMaker.TYPE_DOCUMENT;
                }
                if ((subTypes = NXQLQueryMaker.this.model.getDocumentSubTypes(typeName)) == null) {
                    throw new QueryMaker.QueryMakerException("Unknown type: " + typeName);
                }
                fromTypes.addAll(subTypes);
                boolean isRelation = false;
                do {
                    if (!NXQLQueryMaker.TYPE_RELATION.equals(typeName)) continue;
                    isRelation = true;
                    break;
                } while ((typeName = NXQLQueryMaker.this.model.getDocumentSuperType(typeName)) != null);
                NXQLQueryMaker.this.onlyRelations = NXQLQueryMaker.this.onlyRelations && isRelation;
            }
            Model cfr_ignored_0 = NXQLQueryMaker.this.model;
            fromTypes.remove("Root");
            LiteralList list = new LiteralList();
            for (String type : fromTypes) {
                list.add((Object)new StringLiteral(type));
            }
            this.toplevelOperands.add((Operand)new Expression((Operand)new Reference("ecm:primaryType"), Operator.IN, (Operand)list));
        }

        public void visitWhereClause(WhereClause node) {
            if (node != null) {
                this.analyzeToplevelOperands((Operand)node.predicate);
            }
            this.wherePredicate = new MultiExpression(Operator.AND, this.toplevelOperands);
            super.visitMultiExpression(this.wherePredicate);
        }

        protected void analyzeToplevelOperands(Operand node) {
            if (node instanceof Expression) {
                Expression expr = (Expression)node;
                Operator op = expr.operator;
                if (op == Operator.AND) {
                    this.analyzeToplevelOperands(expr.lvalue);
                    this.analyzeToplevelOperands(expr.rvalue);
                    return;
                }
                if (op == Operator.EQ || op == Operator.NOTEQ) {
                    String name;
                    if (expr.rvalue instanceof Reference) {
                        expr = new Expression(expr.rvalue, op, expr.lvalue);
                    }
                    if (expr.lvalue instanceof Reference && "ecm:isProxy".equals(name = ((Reference)expr.lvalue).name)) {
                        this.analyzeToplevelIsProxy(expr);
                        return;
                    }
                }
            }
            this.toplevelOperands.add(node);
        }

        protected void analyzeToplevelIsProxy(Expression expr) {
            if (!(expr.rvalue instanceof IntegerLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)expr.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            boolean isEq = expr.operator == Operator.EQ;
            Boolean pr = v == 1L == isEq;
            if (NXQLQueryMaker.this.proxyClause != null && NXQLQueryMaker.this.proxyClause != pr) {
                throw new QueryMaker.QueryCannotMatchException();
            }
            NXQLQueryMaker.this.proxyClause = pr;
        }

        public void visitReference(Reference node) {
            if (node.cast != null && !NXQLQueryMaker.DATE_CAST.equals(node.cast)) {
                throw new QueryMaker.QueryMakerException("Invalid cast: " + node);
            }
            String name = node.name;
            if ("ecm:path".equals(name) || "ecm:isProxy".equals(name) || "ecm:mixinType".equals(name) || "ecm:isCheckedInVersion".equals(name)) {
                if (this.inSelect) {
                    throw new QueryMaker.QueryMakerException("Cannot select on column: " + name);
                }
                if (this.inOrderBy) {
                    throw new QueryMaker.QueryMakerException("Cannot order by column: " + name);
                }
                if ("ecm:isCheckedInVersion".equals(name)) {
                    NXQLQueryMaker.this.needsVersionsTable = true;
                }
                return;
            }
            if ("ecm:primaryType".equals(name) || "ecm:uuid".equals(name) || "ecm:name".equals(name) || "ecm:pos".equals(name) || "ecm:parentId".equals(name)) {
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if ("ecm:currentLifeCycleState".equals(name)) {
                Model cfr_ignored_0 = NXQLQueryMaker.this.model;
                this.props.add("ecm:lifeCycleState");
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if ("ecm:versionLabel".equals(name)) {
                Model cfr_ignored_1 = NXQLQueryMaker.this.model;
                this.props.add("ecm:versionLabel");
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if ("ecm:lock".equals(name) || "ecm:lockOwner".equals(name)) {
                Model cfr_ignored_2 = NXQLQueryMaker.this.model;
                this.props.add("ecm:lockOwner");
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if ("ecm:lockCreated".equals(name)) {
                Model cfr_ignored_3 = NXQLQueryMaker.this.model;
                this.props.add("ecm:lockCreated");
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if ("ecm:fulltextJobId".equals(name)) {
                Model cfr_ignored_4 = NXQLQueryMaker.this.model;
                this.props.add("ecm:fulltextJobId");
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if (name.startsWith("ecm:fulltext")) {
                if (NXQLQueryMaker.this.model.getRepositoryDescriptor().fulltextDisabled) {
                    throw new QueryMaker.QueryMakerException("Fulltext disabled by configuration");
                }
                String[] nameref = new String[]{name};
                boolean useIndex = NXQLQueryMaker.findFulltextIndexOrField(NXQLQueryMaker.this.model, nameref);
                if (useIndex) {
                    return;
                }
                name = nameref[0];
            }
            if (name.startsWith("ecm:")) {
                throw new QueryMaker.QueryMakerException("Unknown field: " + name);
            }
            ModelProperty propertyInfo = NXQLQueryMaker.this.model.getPropertyInfo(name);
            if (propertyInfo == null) {
                throw new QueryMaker.QueryMakerException("Unknown field: " + name);
            }
            if (!propertyInfo.propertyType.isArray()) {
                this.props.add(name);
            }
            if (this.inOrderBy) {
                this.orderKeys.add(name);
            }
        }

        public void visitFunction(Function node) {
            throw new QueryMaker.QueryMakerException("Function not supported: " + node.toString());
        }

        public void visitOrderByClause(OrderByClause node) {
            this.inOrderBy = true;
            super.visitOrderByClause(node);
            this.inOrderBy = false;
        }
    }

    public static enum DocKind {
        DIRECT,
        PROXY;

    }
}

