/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.services;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.Reloadable;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.CachingDef;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.NegotiationDef;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.RegistryType;
import org.nuxeo.theme.ViewDef;
import org.nuxeo.theme.engines.EngineType;
import org.nuxeo.theme.models.ModelType;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.presets.PaletteParser;
import org.nuxeo.theme.presets.PaletteType;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.resources.BankImport;
import org.nuxeo.theme.resources.BankManager;
import org.nuxeo.theme.resources.ResourceBank;
import org.nuxeo.theme.resources.ResourceType;
import org.nuxeo.theme.templates.TemplateEngineType;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeIOException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.themes.ThemeParser;
import org.nuxeo.theme.themes.ThemeSet;
import org.nuxeo.theme.themes.ThemeSetEntry;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.views.ViewType;

public class ThemeService
extends DefaultComponent
implements Reloadable {
    public static final ComponentName ID = new ComponentName("org.nuxeo.theme.services.ThemeService");
    private static final Log log = LogFactory.getLog(ThemeService.class);
    private Map<String, Registrable> registries = new HashMap<String, Registrable>();
    private RuntimeContext context;
    protected List<Extension> extensions = new ArrayList<Extension>();

    public Map<String, Registrable> getRegistries() {
        return this.registries;
    }

    public Registrable getRegistry(String name) {
        return this.registries.get(name);
    }

    public synchronized void addRegistry(String name, Registrable registry) {
        this.registries.put(name, registry);
    }

    public synchronized void removeRegistry(String name) {
        Registrable registry = this.registries.get(name);
        if (registry != null) {
            registry.clear();
        }
        this.registries.remove(name);
    }

    public void reload(ComponentContext context) throws Exception {
        this.deactivate(context);
        this.activate(context);
        for (Extension xt : this.extensions) {
            this.doRegisterExtension(xt);
        }
        this.applicationStarted(context);
    }

    public void activate(ComponentContext ctx) {
        this.context = ctx.getRuntimeContext();
        Manager.initializeProtocols();
        log.debug((Object)"Theme service activated");
    }

    public void deactivate(ComponentContext ctx) {
        for (Registrable registry : this.registries.values()) {
            registry.clear();
        }
        this.registries.clear();
        this.context = null;
        Manager.resetProtocols();
        log.debug((Object)"Theme service deactivated");
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        for (ThemeDescriptor themeDescriptor : ThemeManager.getThemeDescriptors()) {
            this.registerTheme(themeDescriptor);
        }
        this.registerCustomThemes();
        ThemeManager.updateThemeDescriptors();
        BankManager.setupBanks();
    }

    public void registerExtension(Extension extension) {
        if (this.doRegisterExtension(extension)) {
            this.extensions.add(extension);
        }
    }

    public boolean doRegisterExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("registries")) {
            this.registerRegistryExtension(extension);
        } else if (xp.equals("elements") || xp.equals("fragments") || xp.equals("formats") || xp.equals("format-filters") || xp.equals("standalone-filters") || xp.equals("negotiations") || xp.equals("shortcuts") || xp.equals("vocabularies")) {
            this.registerTypeExtension(extension);
        } else if (xp.equals("applications")) {
            this.registerApplicationExtension(extension);
        } else if (xp.equals("perspectives")) {
            this.registerPerspectiveExtension(extension);
        } else if (xp.equals("engines")) {
            this.registerEngineExtension(extension);
        } else if (xp.equals("template-engines")) {
            this.registerTemplateEngineExtension(extension);
        } else if (xp.equals("themes")) {
            this.registerThemeExtension(extension);
        } else if (xp.equals("themesets")) {
            this.registerThemeSetExtension(extension);
        } else if (xp.equals("presets")) {
            this.registerPresetExtension(extension);
        } else if (xp.equals("views")) {
            this.registerViewExtension(extension);
        } else if (xp.equals("models")) {
            this.registerModelExtension(extension);
        } else if (xp.equals("resources")) {
            this.registerResourceExtension(extension);
        } else if (xp.equals("banks")) {
            this.registerBank(extension);
        } else {
            log.warn((Object)String.format("Unknown extension point: %s", xp));
            return false;
        }
        return true;
    }

    public void unregisterExtension(Extension extension) {
        if (this.doUnregisterExtension(extension)) {
            this.extensions.remove(extension);
        }
    }

    public boolean doUnregisterExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("registries")) {
            this.unregisterRegistryExtension(extension);
        } else if (xp.equals("elements") || xp.equals("fragments") || xp.equals("formats") || xp.equals("format-filters") || xp.equals("standalone-filters") || xp.equals("engines") || xp.equals("template-engines") || xp.equals("negotiations") || xp.equals("perspectives") || xp.equals("applications") || xp.equals("shortcuts") || xp.equals("vocabularies") || xp.equals("presets") || xp.equals("views") || xp.equals("themes") || xp.equals("themesets")) {
            this.unregisterTypeExtension(extension);
        } else if (xp.equals("resources")) {
            this.unregisterResourceExtension(extension);
        } else if (xp.equals("views")) {
            this.unregisterViewExtension(extension);
        } else if (xp.equals("models")) {
            this.unregisterModelExtension(extension);
        } else if (xp.equals("banks")) {
            this.unregisterBank(extension);
        } else {
            log.warn((Object)String.format("Unknown extension point: %s", xp));
            return false;
        }
        return true;
    }

    private void registerRegistryExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            RegistryType registryType = (RegistryType)contrib;
            Registrable registry = null;
            try {
                registry = (Registrable)this.context.loadClass(registryType.getClassName()).newInstance();
            }
            catch (Exception e) {
                log.warn((Object)("Could not create registry: " + registryType.getName() + "(" + registryType.getClassName() + ")"));
            }
            if (registry == null) continue;
            this.addRegistry(registryType.getName(), registry);
        }
    }

    private void unregisterRegistryExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            RegistryType registryType = (RegistryType)contrib;
            this.removeRegistry(registryType.getName());
        }
    }

    private void registerTypeExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            typeRegistry.register((Type)contrib);
        }
    }

    private void unregisterTypeExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        if (typeRegistry != null) {
            for (Object contrib : contribs) {
                typeRegistry.unregister((Type)contrib);
            }
        }
    }

    private void registerApplicationExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            Map<String, ViewDef> viewDefs;
            CachingDef styleCaching;
            CachingDef resourceCaching;
            NegotiationDef negotiation;
            String templateEngine;
            ApplicationType application = (ApplicationType)contrib;
            ApplicationType oldApplication = (ApplicationType)typeRegistry.lookup(TypeFamily.APPLICATION, application.getTypeName());
            if (oldApplication == null) {
                templateEngine = application.getTemplateEngine();
                if (templateEngine == null) {
                    String defaultTemplateEngine = ThemeManager.getDefaultTemplateEngineName();
                    log.warn((Object)String.format("Please set the 'template-engine' attribute on <application root=\"%s\" template-engine=\"...\"> (default is '%s')", application.getRoot(), defaultTemplateEngine));
                    application.setTemplateEngine(defaultTemplateEngine);
                }
                typeRegistry.register(application);
                continue;
            }
            templateEngine = application.getTemplateEngine();
            if (templateEngine != null) {
                oldApplication.setTemplateEngine(templateEngine);
            }
            if ((negotiation = application.getNegotiation()) != null) {
                NegotiationDef oldNegotiation = oldApplication.getNegotiation();
                if (oldNegotiation == null) {
                    oldNegotiation = new NegotiationDef();
                    oldApplication.setNegotiation(oldNegotiation);
                }
                if (negotiation.getStrategy() != null) {
                    oldNegotiation.setStrategy(negotiation.getStrategy());
                }
                if (negotiation.getDefaultTheme() != null) {
                    oldNegotiation.setDefaultTheme(negotiation.getDefaultTheme());
                }
                if (negotiation.getDefaultPerspective() != null) {
                    oldNegotiation.setDefaultPerspective(negotiation.getDefaultPerspective());
                }
                if (negotiation.getDefaultEngine() != null) {
                    oldNegotiation.setDefaultEngine(negotiation.getDefaultEngine());
                }
            }
            if ((resourceCaching = application.getResourceCaching()) != null) {
                CachingDef oldResourceCaching = oldApplication.getResourceCaching();
                if (oldResourceCaching == null) {
                    oldResourceCaching = new CachingDef();
                    oldApplication.setResourceCaching(oldResourceCaching);
                }
                if (resourceCaching.getLifetime() != null) {
                    oldResourceCaching.setLifetime(resourceCaching.getLifetime());
                }
            }
            if ((styleCaching = application.getStyleCaching()) != null) {
                CachingDef oldStyleCaching = oldApplication.getStyleCaching();
                if (oldStyleCaching == null) {
                    oldStyleCaching = new CachingDef();
                    oldApplication.setStyleCaching(oldStyleCaching);
                }
                if (styleCaching.getLifetime() != null) {
                    oldStyleCaching.setLifetime(styleCaching.getLifetime());
                }
            }
            if ((viewDefs = application.getViewDefs()).isEmpty()) continue;
            Map<String, ViewDef> oldViewDefs = oldApplication.getViewDefs();
            for (Map.Entry<String, ViewDef> entry : viewDefs.entrySet()) {
                oldViewDefs.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void registerPerspectiveExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            PerspectiveType perspective = (PerspectiveType)contrib;
            if (!perspective.getName().matches("[a-z0-9_\\-]+")) {
                log.error((Object)"Perspective names may only contain lowercase alphanumeric characters, underscores and hyphens ");
                continue;
            }
            typeRegistry.register(perspective);
        }
    }

    private void registerEngineExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            EngineType engine = (EngineType)contrib;
            if (!engine.getName().matches("[a-z0-9_\\-]+")) {
                log.error((Object)"Rendering engine names may only contain lowercase alphanumeric characters, underscores and hyphens ");
                continue;
            }
            typeRegistry.register(engine);
        }
    }

    private void registerTemplateEngineExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            TemplateEngineType engine = (TemplateEngineType)contrib;
            if (!engine.getName().matches("[a-z0-9_\\-]+")) {
                log.error((Object)"Template engine names may only contain lowercase alphanumeric characters, underscores and hyphens ");
                continue;
            }
            typeRegistry.register(engine);
        }
    }

    private void registerThemeExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            ThemeDescriptor themeDescriptor = (ThemeDescriptor)contrib;
            themeDescriptor.setContext(extension.getContext());
            themeDescriptor.setConfigured(true);
            typeRegistry.register(themeDescriptor);
        }
    }

    private void registerTheme(ThemeDescriptor themeDescriptor) {
        String src = themeDescriptor.getSrc();
        if (src == null) {
            themeDescriptor.setLoadingFailed(true);
            log.error((Object)"Could not load theme, source not set. ");
            return;
        }
        try {
            boolean preload = true;
            ThemeParser.registerTheme(themeDescriptor, true);
        }
        catch (ThemeIOException e) {
            log.error((Object)("Could not register theme: " + src + " " + e.getMessage()));
        }
    }

    private void registerThemeSetExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            ThemeSet themeSet = (ThemeSet)contrib;
            String name = themeSet.getName();
            ThemeSet oldThemeSet = (ThemeSet)typeRegistry.lookup(TypeFamily.THEMESET, name);
            if (oldThemeSet == null) {
                typeRegistry.register(themeSet);
                continue;
            }
            for (ThemeSetEntry theme : themeSet.getThemes()) {
                String themeName = theme.getName();
                ThemeSetEntry oldTheme = oldThemeSet.getTheme(themeName);
                if (oldTheme == null) {
                    oldTheme = new ThemeSetEntry(themeName);
                    oldThemeSet.setTheme(oldTheme);
                }
                for (String feature : theme.getFeatures()) {
                    oldThemeSet.addFeatureToTheme(themeName, feature);
                }
            }
        }
    }

    private void registerCustomThemes() {
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (File file : ThemeManager.getCustomThemeFiles()) {
            ThemeDescriptor themeDescriptor = new ThemeDescriptor();
            themeDescriptor.setConfigured(false);
            String src = null;
            try {
                src = String.format("file://%s", file.getCanonicalPath());
            }
            catch (Exception e) {
                themeDescriptor.setLoadingFailed(true);
                log.error((Object)("Could not read theme file: " + src));
                continue;
            }
            themeDescriptor.setSrc(src);
            try {
                boolean preload = true;
                ThemeParser.registerTheme(themeDescriptor, true);
            }
            catch (ThemeIOException e) {
                log.error((Object)("Could not register theme: " + src + " " + e.getMessage()));
                continue;
            }
            typeRegistry.register(themeDescriptor);
        }
        log.debug((Object)"Registered local themes");
    }

    private void registerPresetExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        RuntimeContext extensionContext = extension.getContext();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            if (contrib instanceof PaletteType) {
                this.registerPalette((PaletteType)contrib, extensionContext);
                continue;
            }
            typeRegistry.register((Type)contrib);
        }
    }

    private void registerPalette(PaletteType palette, RuntimeContext extensionContext) {
        URL url;
        String category;
        String paletteName;
        TypeRegistry typeRegistry;
        block4: {
            typeRegistry = (TypeRegistry)this.getRegistry("types");
            paletteName = palette.getName();
            String src = palette.getSrc();
            category = palette.getCategory();
            url = null;
            try {
                url = new URL(src);
            }
            catch (MalformedURLException e) {
                url = extensionContext.getLocalResource(src);
                if (url != null) break block4;
                url = extensionContext.getResource(src);
            }
        }
        if (url != null) {
            typeRegistry.register(palette);
            Map<String, String> entries = PaletteParser.parse(url);
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                PresetType preset = new PresetType(entry.getKey(), entry.getValue(), paletteName, category, "", "");
                typeRegistry.register(preset);
            }
        }
    }

    private void registerViewExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            ViewType viewType = (ViewType)contrib;
            String templateEngineName = viewType.getTemplateEngine();
            String viewName = viewType.getViewName();
            String viewTypeName = viewType.getTypeName();
            if (templateEngineName == null) {
                String defaultTemplateEngineName;
                templateEngineName = defaultTemplateEngineName = ThemeManager.getDefaultTemplateEngineName();
                log.warn((Object)String.format("Please set the 'template-engine' attribute on <view name=\"%s\" template-engine=\"...\"> (using default '%s')", viewName, defaultTemplateEngineName));
                continue;
            }
            if (templateEngineName.contains(",")) {
                log.warn((Object)String.format("The 'template-engine' attribute in <view name=\"%s\" template-engine=\"...\"> may only contain a single template-engine name", viewName, templateEngineName));
                templateEngineName = templateEngineName.split(",")[0];
            }
            if (viewType.isMerge()) {
                List<String> newResources;
                ViewType oldViewType = (ViewType)typeRegistry.lookup(TypeFamily.VIEW, viewTypeName);
                if (oldViewType == null || (newResources = viewType.getResources()).isEmpty()) continue;
                log.debug((Object)("Added resources " + newResources + " to THEME view: " + viewTypeName));
                for (String resource : newResources) {
                    oldViewType.addResource(resource);
                }
                continue;
            }
            typeRegistry.register(viewType);
        }
    }

    private void unregisterViewExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        if (typeRegistry != null) {
            for (Object contrib : contribs) {
                typeRegistry.unregister((ViewType)contrib);
            }
        }
    }

    private void registerModelExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        ThemeManager themeManager = (ThemeManager)this.getRegistry("themes");
        for (Object contrib : contribs) {
            ModelType modelType = (ModelType)contrib;
            String modelTypeName = modelType.getTypeName();
            ModelType oldModelType = (ModelType)typeRegistry.lookup(TypeFamily.MODEL, modelTypeName);
            if (oldModelType != null) {
                if (oldModelType.getClassName().equals(modelType.getClassName())) {
                    log.debug((Object)("Model type '" + modelTypeName + "' (" + oldModelType.getClassName() + ") has already been registered."));
                    continue;
                }
                log.warn((Object)("Failed to reregister model type '" + modelTypeName + "' (" + oldModelType.getClassName() + "). The new class " + modelType.getClassName() + " will be ignored."));
                continue;
            }
            typeRegistry.register(modelType);
            themeManager.registerModelByClassname(modelType);
        }
    }

    private void unregisterModelExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        ThemeManager themeManager = (ThemeManager)this.getRegistry("themes");
        if (typeRegistry != null) {
            for (Object contrib : contribs) {
                ModelType modelType = (ModelType)contrib;
                themeManager.unregisterModelByClassname(modelType);
                typeRegistry.unregister(modelType);
            }
        }
    }

    private void registerResourceExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        RuntimeContext extensionContext = extension.getContext();
        for (Object contrib : contribs) {
            if (contrib instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)contrib;
                typeRegistry.register(resourceType);
                continue;
            }
            if (!(contrib instanceof BankImport)) continue;
            BankImport bankImport = (BankImport)contrib;
            String bankName = bankImport.getBankName();
            String collection = bankImport.getCollection();
            String srcFilePath = bankImport.getSrcFilePath();
            URL srcFileUrl = extensionContext.getLocalResource(srcFilePath);
            if (srcFileUrl == null) {
                srcFileUrl = extensionContext.getResource(srcFilePath);
            }
            if (srcFileUrl == null) {
                log.error((Object)("Could not import bank resources: " + srcFilePath + " (resource not found)"));
                continue;
            }
            try {
                BankManager.importBankData(bankName, collection, srcFileUrl);
            }
            catch (IOException e) {
                log.error((Object)("Could not import bank resources: " + srcFilePath + " (" + e.getMessage() + ")"));
            }
        }
        ThemeManager themeManager = (ThemeManager)this.getRegistry("themes");
        themeManager.updateResourceOrdering();
    }

    private void unregisterResourceExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        ThemeManager themeManager = (ThemeManager)this.getRegistry("themes");
        RuntimeContext extensionContext = extension.getContext();
        for (Object contrib : contribs) {
            if (contrib instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)contrib;
                typeRegistry.unregister(resourceType);
                themeManager.unregisterResourceOrdering(resourceType);
                continue;
            }
            if (!(contrib instanceof BankImport)) continue;
            BankImport bankImport = (BankImport)contrib;
            String bankName = bankImport.getBankName();
            String srcFilePath = bankImport.getSrcFilePath();
        }
    }

    private void registerBank(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            if (!(contrib instanceof ResourceBank)) continue;
            ResourceBank resourceBank = (ResourceBank)contrib;
            typeRegistry.register(resourceBank);
        }
    }

    private void unregisterBank(Extension extension) {
        Object[] contribs = extension.getContributions();
        TypeRegistry typeRegistry = (TypeRegistry)this.getRegistry("types");
        for (Object contrib : contribs) {
            if (!(contrib instanceof ResourceBank)) continue;
            ResourceBank resourceBank = (ResourceBank)contrib;
            typeRegistry.unregister(resourceBank);
        }
    }
}

