/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.SAXException;

public class HtmlParser
extends AbstractSAXParser {
    private static final Log log = LogFactory.getLog(HtmlParser.class);
    protected StringBuilder buffer;
    protected String tagFilter;
    protected Boolean inFilter;
    protected Boolean noFilter;
    protected String skipUntillClosed;
    protected final Set<String> newLinesTags = new HashSet<String>();
    protected final Set<String> skippedTags = new HashSet<String>();

    public HtmlParser() {
        super((XMLParserConfiguration)new HTMLConfiguration());
        this.init(null);
    }

    public HtmlParser(String tagFilter) {
        super((XMLParserConfiguration)new HTMLConfiguration());
        this.init(tagFilter);
    }

    public void init(String tagFilter) {
        try {
            this.setFeature("http://xml.org/sax/features/validation", false);
            this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            log.debug((Object)("Could not switch parser to non-validating: " + e.getMessage()));
        }
        this.inFilter = false;
        if (tagFilter == null || "".equals(tagFilter)) {
            this.noFilter = true;
        } else {
            this.tagFilter = tagFilter;
            this.noFilter = false;
        }
        this.skippedTags.add("script");
        this.skippedTags.add("style");
        this.skippedTags.add("link");
        this.newLinesTags.add("div");
        this.newLinesTags.add("p");
        this.newLinesTags.add("br");
        this.newLinesTags.add("pre");
        this.newLinesTags.add("h1");
        this.newLinesTags.add("h2");
        this.newLinesTags.add("h3");
        this.newLinesTags.add("h4");
        this.newLinesTags.add("h5");
        this.newLinesTags.add("h6");
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) {
        super.startElement(element, attributes, augs);
        if (!this.noFilter.booleanValue() && this.tagFilter.equalsIgnoreCase(element.localpart)) {
            this.inFilter = true;
        }
        if (this.skipUntillClosed == null && this.skippedTags.contains(element.localpart.toLowerCase())) {
            this.skipUntillClosed = element.localpart.toLowerCase();
        }
    }

    public void endElement(QName element, Augmentations augs) {
        super.endElement(element, augs);
        if (!this.noFilter.booleanValue() && this.tagFilter.equals(element.localpart)) {
            this.inFilter = false;
        }
        if (this.skipUntillClosed != null && this.skipUntillClosed.equals(element.localpart.toLowerCase())) {
            this.skipUntillClosed = null;
        }
        if (this.newLinesTags.contains(element.localpart.toLowerCase())) {
            this.buffer.append("\n\n");
        }
    }

    public void startDocument(XMLLocator arg0, String arg1, NamespaceContext arg2, Augmentations arg3) {
        super.startDocument(arg0, arg1, arg2, arg3);
        this.buffer = new StringBuilder();
    }

    public void characters(XMLString xmlString, Augmentations augmentations) {
        super.characters(xmlString, augmentations);
        if ((this.noFilter.booleanValue() || this.inFilter.booleanValue()) && this.skipUntillClosed == null) {
            this.buffer.append(xmlString.toString());
        }
    }

    public String getContents() {
        String text = this.buffer.toString();
        text = text.replaceAll(" *\n", "\n");
        text = text.replaceAll(" +", " ");
        text = text.replaceAll("\\n\\n+", "\n\n");
        return text;
    }
}

