/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OOoXmlContentHandler
extends DefaultHandler {
    protected final StringBuffer sb = new StringBuffer();
    protected final Stack<String> path = new Stack();
    protected boolean dumpText = false;

    public String getContent() {
        return this.sb.toString();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.path.push(qName);
        if (qName.startsWith("text:")) {
            this.dumpText = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.dumpText) {
            String content = String.valueOf(ch, start, length);
            this.sb.append(content);
            this.sb.append(" ");
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.path.pop();
        if (this.path.isEmpty() || !((String)this.path.lastElement()).startsWith("text:")) {
            this.dumpText = false;
        }
    }
}

