/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Iterator;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import org.richfaces.component.Column;
import org.richfaces.component.DataIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FixedChildrenIterator
extends DataIterator {
    private Iterator<UIComponent> currentColumnIterator;

    public FixedChildrenIterator(UIComponent dataTable) {
        super(dataTable);
    }

    @Override
    protected UIComponent nextColumn() {
        UIComponent nextColumn = null;
        if (null != this.currentColumnIterator) {
            nextColumn = this.currentColumnIterator.next();
            this.checkNextColumnChild();
        } else {
            while (null == nextColumn && this.childrenIterator.hasNext()) {
                UIComponent child = (UIComponent)this.childrenIterator.next();
                if (child instanceof UIColumn || child instanceof Column) {
                    Iterator<UIComponent> iterator;
                    boolean rendered = true;
                    try {
                        rendered = child.isRendered();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!rendered || !(iterator = this.getColumnChildrenIterator(child)).hasNext()) continue;
                    this.currentColumnIterator = iterator;
                    nextColumn = this.currentColumnIterator.next();
                    this.checkNextColumnChild();
                    continue;
                }
                if (!this.checkAjaxComponent(child)) continue;
                nextColumn = child;
            }
        }
        if (null == nextColumn) {
            nextColumn = this.getNextFacet();
        }
        return nextColumn;
    }

    protected UIComponent getNextFacet() {
        UIComponent nextColumn = null;
        while (null == nextColumn && this.facetsIterator.hasNext()) {
            UIComponent child = (UIComponent)this.facetsIterator.next();
            if (!this.checkAjaxComponent(child)) continue;
            nextColumn = child;
        }
        return nextColumn;
    }

    @Override
    protected boolean checkAjaxComponent(UIComponent child) {
        return !super.checkAjaxComponent(child);
    }

    @Override
    protected Iterator<UIComponent> getColumnChildrenIterator(UIComponent child) {
        return child.getFacets().values().iterator();
    }

    protected void checkNextColumnChild() {
        if (!this.currentColumnIterator.hasNext()) {
            this.currentColumnIterator = null;
        }
    }
}

