/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.MultiFilingService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.MultiFilingServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RelationshipService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RelationshipServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractPortProvider {
    private static final Log log = LogFactory.getLog(AbstractPortProvider.class);
    public static final String CMIS_NAMESPACE = "http://docs.oasis-open.org/ns/cmis/ws/200908/";
    public static final String REPOSITORY_SERVICE = "RepositoryService";
    public static final String OBJECT_SERVICE = "ObjectService";
    public static final String DISCOVERY_SERVICE = "DiscoveryService";
    public static final String NAVIGATION_SERVICE = "NavigationService";
    public static final String MULTIFILING_SERVICE = "MultiFilingService";
    public static final String VERSIONING_SERVICE = "VersioningService";
    public static final String RELATIONSHIP_SERVICE = "RelationshipService";
    public static final String POLICY_SERVICE = "PolicyService";
    public static final String ACL_SERVICE = "ACLService";
    protected static final int CHUNK_SIZE = 65536;
    protected Session session;

    public RepositoryServicePort getRepositoryServicePort() {
        return (RepositoryServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.RepositoryService");
    }

    public NavigationServicePort getNavigationServicePort() {
        return (NavigationServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.NavigationService");
    }

    public ObjectServicePort getObjectServicePort() {
        return (ObjectServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.ObjectService");
    }

    public VersioningServicePort getVersioningServicePort() {
        return (VersioningServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.VersioningService");
    }

    public DiscoveryServicePort getDiscoveryServicePort() {
        return (DiscoveryServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService");
    }

    public MultiFilingServicePort getMultiFilingServicePort() {
        return (MultiFilingServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService");
    }

    public RelationshipServicePort getRelationshipServicePort() {
        return (RelationshipServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.RelationshipService");
    }

    public PolicyServicePort getPolicyServicePort() {
        return (PolicyServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.PolicyService");
    }

    public ACLServicePort getACLServicePort() {
        return (ACLServicePort)this.getPortObject("org.apache.chemistry.opencmis.binding.webservices.ACLService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getPortObject(String serviceKey) {
        Map<String, Service> serviceMap = (Map<String, Service>)this.session.get("org.apache.chemistry.opencmis.binding.webservices.services");
        if (serviceMap == null) {
            this.session.writeLock();
            try {
                serviceMap = (Map)this.session.get("org.apache.chemistry.opencmis.binding.webservices.services");
                if (serviceMap == null) {
                    serviceMap = Collections.synchronizedMap(new HashMap());
                    this.session.put("org.apache.chemistry.opencmis.binding.webservices.services", serviceMap, true);
                }
                if (serviceMap.containsKey(serviceKey)) {
                    Object object = this.createPortObject((Service)serviceMap.get(serviceKey));
                    return object;
                }
                Service serviceObject = this.initServiceObject(serviceKey);
                serviceMap.put(serviceKey, serviceObject);
                Object object = this.createPortObject(serviceObject);
                return object;
            }
            finally {
                this.session.writeUnlock();
            }
        }
        if (!serviceMap.containsKey(serviceKey)) {
            this.session.writeLock();
            try {
                if (serviceMap.containsKey(serviceKey)) {
                    Object serviceObject = this.createPortObject((Service)serviceMap.get(serviceKey));
                    return serviceObject;
                }
                Service serviceObject = this.initServiceObject(serviceKey);
                serviceMap.put(serviceKey, serviceObject);
                Object object = this.createPortObject(serviceObject);
                return object;
            }
            finally {
                this.session.writeUnlock();
            }
        }
        return this.createPortObject((Service)serviceMap.get(serviceKey));
    }

    protected Service initServiceObject(String serviceKey) {
        RepositoryService serviceObject;
        block13: {
            serviceObject = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing Web Service " + serviceKey + "..."));
            }
            try {
                URL wsdlUrl = new URL((String)this.session.get(serviceKey));
                if ("org.apache.chemistry.opencmis.binding.webservices.RepositoryService".equals(serviceKey)) {
                    serviceObject = new RepositoryService(wsdlUrl, new QName(CMIS_NAMESPACE, REPOSITORY_SERVICE));
                    break block13;
                }
                if ("org.apache.chemistry.opencmis.binding.webservices.NavigationService".equals(serviceKey)) {
                    serviceObject = new NavigationService(wsdlUrl, new QName(CMIS_NAMESPACE, NAVIGATION_SERVICE));
                    break block13;
                }
                if ("org.apache.chemistry.opencmis.binding.webservices.ObjectService".equals(serviceKey)) {
                    serviceObject = new ObjectService(wsdlUrl, new QName(CMIS_NAMESPACE, OBJECT_SERVICE));
                    break block13;
                }
                if ("org.apache.chemistry.opencmis.binding.webservices.VersioningService".equals(serviceKey)) {
                    serviceObject = new VersioningService(wsdlUrl, new QName(CMIS_NAMESPACE, VERSIONING_SERVICE));
                    break block13;
                }
                if ("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService".equals(serviceKey)) {
                    serviceObject = new DiscoveryService(wsdlUrl, new QName(CMIS_NAMESPACE, DISCOVERY_SERVICE));
                    break block13;
                }
                if ("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService".equals(serviceKey)) {
                    serviceObject = new MultiFilingService(wsdlUrl, new QName(CMIS_NAMESPACE, MULTIFILING_SERVICE));
                    break block13;
                }
                if ("org.apache.chemistry.opencmis.binding.webservices.RelationshipService".equals(serviceKey)) {
                    serviceObject = new RelationshipService(wsdlUrl, new QName(CMIS_NAMESPACE, RELATIONSHIP_SERVICE));
                    break block13;
                }
                if ("org.apache.chemistry.opencmis.binding.webservices.PolicyService".equals(serviceKey)) {
                    serviceObject = new PolicyService(wsdlUrl, new QName(CMIS_NAMESPACE, POLICY_SERVICE));
                    break block13;
                }
                if ("org.apache.chemistry.opencmis.binding.webservices.ACLService".equals(serviceKey)) {
                    serviceObject = new ACLService(wsdlUrl, new QName(CMIS_NAMESPACE, ACL_SERVICE));
                    break block13;
                }
                throw new CmisRuntimeException("Cannot find Web Services service object [" + serviceKey + "]!");
            }
            catch (CmisBaseException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new CmisConnectionException("Cannot initalize Web Services service object [" + serviceKey + "]: " + e.getMessage(), (Throwable)e);
            }
        }
        return serviceObject;
    }

    protected abstract Object createPortObject(Service var1);
}

