/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types.ejb;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.ejb.TypeManagerLocal;
import org.nuxeo.runtime.api.Framework;

@Stateless
@Local(value={TypeManagerLocal.class})
@Remote(value={TypeManager.class})
public class TypeManagerBean
implements TypeManagerLocal {
    private static final Log log = LogFactory.getLog(TypeManagerBean.class);
    protected TypeManager typeService;

    @Override
    @PostConstruct
    public void initialize() {
        this.typeService = (TypeManager)Framework.getLocalService(TypeManager.class);
    }

    public String[] getSuperTypes(String typeName) {
        try {
            return this.getTypeService().getSuperTypes(typeName);
        }
        catch (Exception e) {
            log.error((Object)"Failed to lookup the SchemaManager service", (Throwable)e);
            return new String[0];
        }
    }

    public Type getType(String typeName) {
        return this.getTypeService().getType(typeName);
    }

    public boolean hasType(String typeName) {
        return this.getTypeService().hasType(typeName);
    }

    public Collection<Type> getTypes() {
        return this.getTypeService().getTypes();
    }

    public Collection<Type> getAllowedSubTypes(String typeName) {
        return this.getTypeService().getAllowedSubTypes(typeName);
    }

    public Collection<Type> getAllowedSubTypes(String typeName, DocumentModel currentDoc) {
        return this.typeService.getAllowedSubTypes(typeName, currentDoc);
    }

    public Collection<Type> findAllAllowedSubTypesFrom(String typeName) {
        return this.typeService.findAllAllowedSubTypesFrom(typeName);
    }

    public Collection<Type> findAllAllowedSubTypesFrom(String typeName, DocumentModel currentDoc) {
        return this.typeService.findAllAllowedSubTypesFrom(typeName, currentDoc);
    }

    public Map<String, List<Type>> getTypeMapForDocumentType(String type, DocumentModel currentDoc) {
        return this.typeService.getTypeMapForDocumentType(type, currentDoc);
    }

    public boolean canCreate(String typeName, String containerTypeName) {
        return this.typeService.canCreate(typeName, containerTypeName);
    }

    public boolean canCreate(String typeName, String containerTypeName, DocumentModel currentDoc) {
        return this.typeService.canCreate(typeName, containerTypeName, currentDoc);
    }

    public boolean isAllowedSubType(String typeName, String containerTypeName) {
        return this.typeService.isAllowedSubType(typeName, containerTypeName);
    }

    public boolean isAllowedSubType(String typeName, String containerTypeName, DocumentModel currentDoc) {
        return this.typeService.isAllowedSubType(typeName, containerTypeName, currentDoc);
    }

    @Override
    @Remove
    public void remove() {
        this.typeService = null;
    }

    private TypeManager getTypeService() {
        if (this.typeService == null) {
            this.initialize();
        }
        return this.typeService;
    }
}

